/*

Program to read temperature and humidity over I2C
from the GE ChipCap2 sensor, using the MBED LPC11U24 board.

Autor: Mario Baldini <mario@baldini.systems>
2014/08

Reading the output (in linux): sudo screen /dev/ttyACM0 115200


*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
I2C i2c(p28,p27);   //sda,scl


int main() {
    
    pc.baud(115200);

    i2c.frequency(400000);
    char wake_cmd[3];
    char data[4];
    float humidity;
    float temperatureC;
    const int addr = 0x28 << 1;

    while(true) {

        data[0] = 0x00;   
        data[1] = 0x00;
        data[2] = 0x00;
        data[3] = 0x00;

        wake_cmd[0] = 0xA0;
        wake_cmd[1] = 0x00;
        wake_cmd[1] = 0x00;
        i2c.write(addr, wake_cmd, 3);
    
        wait_ms(50);
        
        
        i2c.read(addr, data, 4);
        
        pc.printf("Raw Data[]\t 0x%X   0x%X   0x%X   0x%X \r\n", data[0],data[1],data[2],data[3]);

        humidity = (((data[0] & 63) << 8) + data[1]) / 163.84;
        temperatureC = (((data[2] << 6) + (data[3] / 4)) / 99.29) - 40; 
        pc.printf("Humidity: %.2f \t Temperature (C): %.2f \r\n\n", humidity, temperatureC);

        wait_ms(1000);
    }
}
