#include "mbed.h"
#include "USBSerial.h"
#include "TextLCD.h"

//an LED to display activity
DigitalOut serial_activity_led(LED2);
//Virtual serial port over USB
USBSerial serial;
//The TextLCD
TextLCD lcd(p21, p22, p17, p18, p19, p20); // rs, e, d4-d7

int main() {
    //initialise the LCD
    lcd.printf("FlightSimInstru\nready!");
    
    //setup some buffers - could use ints, too, but this way we can let the PC decide on the units, use floats etc.
    uint8_t ias[128];
    uint8_t alt[128];
    //clear them
    memset(ias,0,sizeof(ias)*sizeof(*ias));
    memset(alt,0,sizeof(alt)*sizeof(*alt));
    
    //toggle an LED to show us, that the mbed is alive.
    while(1) {
        //read two space separated strings
        serial.scanf("%s %s", ias, alt);
        //write them on the LCD
        lcd.cls();
        lcd.printf("Speed: %s\nAlt: %s", ias, alt);
        //toggle activity LED
        serial_activity_led = !serial_activity_led;
    }
}
