#include "mbed.h"
#include "TextLCD.h"
#include "USBHID.h"

//for debugging
Serial pc(USBTX, USBRX);

//an LED to display activity
DigitalOut hid_activity_led(LED2);
DigitalOut alive_led(LED1);

//The TextLCD
TextLCD lcd(p21, p22, p17, p18, p19, p20); // rs, e, d4-d7

//the mbed doesn't return the report ID.
union hid_report_t {
    uint8_t bytes[sizeof(int16_t)*2];
    struct {
        uint16_t health;
        uint16_t ammo;
    } data;
};

//We declare a USBHID device.
// output report size = 1 (not needed here)
// input report size matches the one defined above
USBHID hid(sizeof(int16_t)*2, 1);

//This report will contain data to be received
HID_REPORT recv_report;

int main() {
    //initialise the LCD
    lcd.printf("     CRYSIS\n  Maximum mbed");
    pc.printf("ready!\r\n");
    uint16_t health, ammo;
    
    while(1) {
        if(hid.readNB(&recv_report)) {
            pc.printf("recv[%d]: ", recv_report.length);
            for(int i = 0; i < recv_report.length; i++) {
                pc.printf("%d ", recv_report.data[i]);
            }
            pc.printf("\r\n");

            //receive data
            hid_report_t* pHidData = (hid_report_t*)(recv_report.data);
            
            //for some reason, the byte order has been changed!
            //negative number support will need sign extension
            health = __REV16(pHidData->data.health);
            ammo = __REV16(pHidData->data.ammo);
            
            //for debugging...
            //pc.printf("Health: %d, Ammo: %d\r\n", health, ammo);
            //pc.printf("HEX: Health: %x, Ammo: %x\r\n", health, ammo);
            
            //write new values on screen.
            lcd.cls();
            lcd.printf("Health: %d\nAmmo: %d", health, ammo);
            hid_activity_led = hid_activity_led == 0 ? 1 : 0;//show HID activity
        }
        
        //toggle an LED to show us, that the mbed is alive.
        wait(0.1);
        alive_led = alive_led == 0 ? 1 : 0;
    }
}
