#include "mbed.h"
#include "HeartBeat.h"

HeartBeat::HeartBeat( PinName pwm) : pwmObject(pwm)
{
}


void HeartBeat::pwmIt(float frequency)
{
    float delay = frequency /100;
    
    if (delay < .001){
        delay = .003;
    }
    
    

    for(float p = 0.0f; p < 1.0f; p += 0.01f) {
        pwmObject = p;
        wait(delay);
    }

    for(float p = 1.0f; p > 0.0f; p -= 0.01f) {
        pwmObject = p;
        wait(delay);
    }


}