#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "stdio.h"

uLCD_4DGL uLCD(p13,p14,p30);
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);
Mutex lcd_mutex;


void thread1(void const *args)
{
    while(true) {         // thread loop
        RGBLED_r = 0.5 + (rand() % 11)/20.0;
        RGBLED_g = 0.5 + (rand() % 11)/20.0;
        RGBLED_b = 0.5 + (rand() % 11)/20.0;
        Thread::wait(300);    // wait 1.5s
    }
}

void thread2(void const *args)
{
    while(true) {         // thread loop
        lcd_mutex.lock();
        // basic printf demo = 16 by 18 characters on screen
        uLCD.printf("\nHello uLCD World\n"); //Default Green on black text
        uLCD.printf("\n  Starting Demo...");
        uLCD.text_width(4); //4X size text
        uLCD.text_height(4);
        uLCD.color(RED);
        for (int i=10; i>=6; --i) {
            uLCD.locate(1,2);
            uLCD.printf("%2D",i);
            wait(.5);
        }
        uLCD.cls();
        lcd_mutex.unlock();
        Thread::wait(1000);
    }
}


void thread3(void const *args)
{
    while(true) {         // thread loop
        lcd_mutex.lock();
        // basic printf demo = 16 by 18 characters on screen
        uLCD.printf("\nHello uLCD World\n"); //Default Green on black text
        uLCD.printf("\n  Starting Demo...");
        uLCD.text_width(4); //4X size text
        uLCD.text_height(4);
        uLCD.color(RED);
        for (int i=5; i>=0; --i) {
            uLCD.locate(1,2);
            uLCD.printf("%2D",i);
            wait(.5);
        }
        uLCD.cls();
        lcd_mutex.unlock();
        Thread::wait(1000);
    }
}

int main() {
    Thread t1(thread1);
    Thread t2(thread2);
    Thread t3(thread3);
    while(1) {
        lcd_mutex.lock();
        lcd_mutex.unlock();
        Thread::wait(500);
    }
}
