#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "SerialRPCInterface.h"
#include "HX711.h"
#include "TextLCD.h"

#define BLINKING_RATE  0.5
#define temps_on 0.5

// LR 2/2/17
// sur ce fichier j'ai rajouté une variable RPC count que je peux lire à distance
// adresse/rpc/count/read/

// LCD and Joystick Setting
TextLCD lcd(p8, p10, p11, p5, p6, p7); // rs, e, d4-d7
         //rs   e    d4  d5   d6    d7          
DigitalOut RW(p9);

//LED MBED
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//LED BICOLORE
DigitalOut ledB1(p29); // SI 1 LED ROUGE
DigitalOut ledB2(p30); // SI 1 LED VERT

//AnalogIn Pot1(p19, "pot1");
//AnalogIn Pot2(p20, "pot2");


// BOUTON
DigitalIn Up(p12);
DigitalIn Down(p13);
DigitalIn Left(p14);
DigitalIn Right(p15);
DigitalIn Center(p16);

//HX711
HX711 scale1(p22, p21); //22 , 21
HX711 scale2(p24, p23); //24 , 23


int count = 0 ;
//int F1 = 0 ;
//int F2 = 0 ;


//int pot1 ; a renplacer
//int pot2; a remplacer 

float calibration_factor1 = 2325; //2325 // -7050 worked for my 440lb max scale setup
float calibration_factor2 = 2178; //2178
int averageSamples = 5; //NOMBRE DE MESURE

int moyenneClick = 0;
int boucleExecute = 0;

int menu = 0;

float m = 0; //MASSE en g
float lg = 0; //LG en cm
float MOI = 0; // MOI en kg*cm2
float massMoy = 0; //Moyenne de la masse a chaque points

float weight1 = 0; // F0
float weight2 = 0; // F1

int f0 = 0;
int f1 = 0;

//SWINGWEIGHT
float convertionInches = 2.54; // 1 inches = 2,54 centimètre
float calculInches = 0; // Variable pour effectuer des calculs
float SW = 0; // Variable résultat SWINGWEIGHT

RPCVariable<int> rpc_f0(&f0, "f0");
RPCVariable<int> rpc_f1(&f1, "f1");


RPCVariable<int> rpc_count(&count, "count");
LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;

int main() {

  //Mettre la LED bicolore en ROUGE pendant la tare
  ledB1 = 1;
  ledB2 = 0;
  RW = 0;
  
   scale1.setScale(0);
   scale1.tare(); //Reset the scale to 0

   scale2.setScale(0);
   scale2.tare(); //Reset the scale to 0
   
   long zero_factor1 = scale1.averageValue(averageSamples); //Get a baseline reading / Obtenez une lecture de base CAPTEUR 1
   long zero_factor2 = scale2.averageValue(averageSamples); //Get a baseline reading / Obtenez une lecture de base CAPTEUR 2

  Base::add_rpc_class<DigitalOut>();

  printf("Setting up...\n");
  
  // modif LR config IP manuelle sinon dhcp 
  /*
  EthernetNetIf eth( IpAddr(10,119,24,230), // IP
                     IpAddr(255,255,252,0), // Subnet mask
                     IpAddr(10,119,24,245),   // Gateway
                     IpAddr(10,119,24,245) ); // DNS
                     
    */                 
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  // on définit où seront stockés les fichiers !
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello"); // http://a.b.c.d/hello : hello world !
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");

  Timer tm;
  tm.start();
  //Listen indefinitely
  
  
  // Mettre la LED en VERT pour indiquer la fin de la tare
  ledB1 = 0;
  ledB2 = 1;
  
  while(true)
  {
    scale1.setScale(calibration_factor1); //Adjust to this calibration factor / Ajuster à ce facteur d'étalonnage
    scale2.setScale(calibration_factor2); //Adjust to this calibration factor / Ajuster à ce facteur d'étalonnage
    
    //------------------------------ MESURE PRINCIPAL PIERRE ------------------------------
    if (moyenneClick == 0) {
      weight1 = scale1.getGram();
      weight2 = scale2.getGram();
      
      f0 = (int) weight1;
      f1 = (int) weight2;
    }
    
    m = weight1 - weight2; // Calcul masse du club
    lg = 45 * (weight1 / m); //Longueur jusqu'aux points d'équilibre

    MOI = m * (lg * lg); // Calcul masse du MOI (masse inertielle)

    calculInches = lg / convertionInches; //Convertion en inches
    SW = (calculInches - 14) * m; //Calcul SWINGWEIGHT
    //------------------------------ MESURE PRINCIPAL PIERRE ------------------------------
    
    //F1 = 1000*Pot1.read();
    //F2 =  1000*Pot2.read();
    
    //pot2 = 926;
    //pot1 = 351;
     
     printf("w1 = %f g : w2 = %f g \n", weight1 , weight2);
     printf("f0 = %d g : f1 = %d g \n", f0 , f1);
     Net::poll();
    
    
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      count ++ ;
      tm.start();
    }
    
    
     /*
     
          m = f1 - f0 ;
        lg = (l1*f1)/(f1-f0);
        MOI = m*lg*lg/1000 ;*/

switch (menu) {
    case 0: {
      //LED_BOUTON_B
      ledB1 = 0;
      ledB2 = 1;

      lcd.cls(); //CLEAR LCD
      lcd.locate(0, 0); //Ecrire sur la 1er ligne
      lcd.printf("F1: %.2fg\n", weight1); // Afficher le poids en grammes du capteur 1

      lcd.locate(0, 1); //Ecrire sur la 2ème ligne
      lcd.printf("F0: %.2fg\n", weight2); // Afficher le poids en grammes du capteur 2

      if (!Center) {
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        weight1 = 0;
        weight2 = 0;

        wait(1.5); // Attendre 1.5 sec

        while (moyenneClick == 0) {

          boucleExecute++;

          weight1 = weight1 + scale1.getGram();
          weight2 = weight2 + scale2.getGram();

          m = weight1 - weight2; // Calcul masse du club

          massMoy = massMoy + m;

          wait(0.1); // Attendre 0.1 sec

          massMoy = massMoy / boucleExecute;

          lcd.cls(); //CLEAR LCD
          lcd.locate(0, 0); //Ecrire sur la 1er ligne
          lcd.printf("Nombre de points\n"); // Afficher le nombre de points

          lcd.locate(0, 1); //Ecrire sur la 1er ligne
          lcd.printf("%d   m: %.2fg\n", boucleExecute, massMoy); // Afficher le nombre de points

          //LED VERT
          ledB1 = 0;
          ledB2 = 1;

          //LED ROUGE
          ledB1 = 1;
          ledB2 = 0;

          massMoy = 0;

          if (!Center) {
            //LED ROUGE
            ledB1 = 0;
            ledB2 = 1;
            moyenneClick = 1; //Mettre moyenneClick a 1
            wait(1); // Attendre 1 sec
          }

        }

        weight1 = weight1 / boucleExecute;
        weight2 = weight2 / boucleExecute;

        wait(0.5); // Attendre 0.5 sec
      } else if (!Down) {
        menu = 1;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      } else if (!Up) {
        menu = 3;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      }
    }
    break;

    case 1: {
      //LED_BOUTON_B
      ledB1 = 0;
      ledB2 = 1;

      lcd.cls(); //CLEAR LCD
      lcd.locate(0, 0); //Ecrire sur la 1er ligne
      lcd.printf("m = %.2fg\n", m);

      lg = 45 * (weight1 / m);
      lcd.locate(0, 1); //Ecrire sur la 2ème ligne
      lcd.printf("lg = %.2fcm\n", lg);

      if (!Down) {
        menu = 2;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;
        wait(0.5); // Attendre 0.5 sec
      } else if (!Up) {
        menu = 0;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      }

    }
    break;

    case 2: {
      //LED_BOUTON_B
      ledB1 = 0;
      ledB2 = 1;

      lcd.cls(); //CLEAR LCD
      lcd.locate(0, 0); //Ecrire sur la 1er ligne
      lcd.printf("MOI:\n");
      lcd.locate(0, 1); //Ecrire sur la 2ème ligne
      lcd.printf("%.2f kg.cm2\n", MOI / 1000);

      if (!Down) {
        menu = 3;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      } else if (!Up) {
        menu = 1;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      }
    }
    break;

    case 3: {
      //LED_BOUTON_B
      ledB1 = 0;
      ledB2 = 1;

      lcd.cls(); //CLEAR LCD
      lcd.locate(0, 0); //Ecrire sur la 1er ligne

      lcd.printf("SW = %.2f\n", SW);

      lcd.locate(0, 1); //Ecrire sur la 2ème ligne

      // Résultat de SW (SWINGWEIGHT / inertie) place le club dans une catégorie
      if (SW < 5250) {
        lcd.printf("SWINGWEIGHT NULL\n", SW);
      } else if (SW > 5250 && SW < 5300) {
        lcd.printf("SWINGWEIGHT = B4\n");
      } else if (SW > 5300 && SW < 5350) {
        lcd.printf("SWINGWEIGHT = B5\n");
      } else if (SW > 5350 && SW < 5400) {
        lcd.printf("SWINGWEIGHT = B6\n");
      } else if (SW > 5400 && SW < 5450) {
        lcd.printf("SWINGWEIGHT = B7\n");
      } else if (SW > 5450 && SW < 5500) {
        lcd.printf("SWINGWEIGHT = B8\n");
      } else if (SW > 5500 && SW < 5550) {
        lcd.printf("SWINGWEIGHT = B9\n");
      } else if (SW > 5550 && SW < 5600) {
        lcd.printf("SWINGWEIGHT = C0\n");
      } else if (SW > 5600 && SW < 5650) {
        lcd.printf("SWINGWEIGHT = C1\n");
      } else if (SW > 5650 && SW < 5700) {
        lcd.printf("SWINGWEIGHT = C2\n");
      } else if (SW > 5700 && SW < 5750) {
        lcd.printf("SWINGWEIGHT = C3\n");
      } else if (SW > 5750 && SW < 5800) {
        lcd.printf("SWINGWEIGHT = C4\n");
      } else if (SW > 5800 && SW < 5850) {
        lcd.printf("SWINGWEIGHT = C5\n");
      } else if (SW > 5850 && SW < 5900) {
        lcd.printf("SWINGWEIGHT = C6\n");
      } else if (SW > 5900 && SW < 5950) {
        lcd.printf("SWINGWEIGHT = C7\n");
      } else if (SW > 5950 && SW < 6000) {
        lcd.printf("SWINGWEIGHT = C8\n");
      } else if (SW > 6000 && SW < 6050) {
        lcd.printf("SWINGWEIGHT = C9\n");
      } else if (SW > 6050 && SW < 6100) {
        lcd.printf("SWINGWEIGHT = D0\n");
      } else if (SW > 6100 && SW < 6150) {
        lcd.printf("SWINGWEIGHT = D1\n");
      } else if (SW > 6150 && SW < 6200) {
        lcd.printf("SWINGWEIGHT = D2\n");
      } else if (SW > 6200 && SW < 6250) {
        lcd.printf("SWINGWEIGHT = D3\n");
      } else if (SW > 6250 && SW < 6300) {
        lcd.printf("SWINGWEIGHT = D4\n");
      } else if (SW > 6300 && SW < 6350) {
        lcd.printf("SWINGWEIGHT = D5\n");
      } else if (SW > 6350 && SW < 6400) {
        lcd.printf("SWINGWEIGHT = D6\n");
      } else if (SW > 6400 && SW < 6450) {
        lcd.printf("SWINGWEIGHT = D7\n");
      } else if (SW > 6450 && SW < 6500) {
        lcd.printf("SWINGWEIGHT = D8\n");
      } else if (SW > 6500) {
        lcd.printf("SWINGWEIGHT = D9\n");
      }

      if (!Down) {
        menu = 4;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      } else if (!Up) {
        menu = 2;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      }
    }
    break;

    case 4: {
      //LED_BOUTON_B
      ledB1 = 0;
      ledB2 = 1;

      lcd.cls(); //CLEAR LCD
      lcd.locate(0, 0); //Ecrire sur la 1er ligne

      lcd.printf("N points moyenne");

      lcd.locate(0, 1); //Ecrire sur la 2eme ligne
      lcd.printf("%d\n", boucleExecute);

      if (!Down) {
        menu = 0;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      } else if (!Up) {
        menu = 3;
        //CODE: LED_BOUTON_A
        ledB1 = 1;
        ledB2 = 0;

        wait(0.5); // Attendre 0.5 sec
      }
    }
    break;
           // http://192.168.1.102/rpc/pot1/read dans le navigateur permet de lire l'état du potard !
  } //FIN SWITCH
  
} //FIN WHILE
} //FIN MAIN