#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"
#include "ITG3200.h"
#include "MMA7660FC.h" 

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p13, p14, p19, p26, "WWNet", "mmmmmmmm", WPA);
DigitalOut led1(LED1);
DigitalOut led2(LED1);
//gyrc
ITG3200 gyro(p9, p10, 0x68);
//3Axis
#define ADDR_MMA7660 0x98                   // I2C SLAVE ADDR MMA7660FC
MMA7660FC Acc(p28, p27, ADDR_MMA7660);      //sda, scl, Addr
float G_VALUE[64] = {0, 0.047, 0.094, 0.141, 0.188, 0.234, 0.281, 0.328, 0.375, 0.422, 0.469, 0.516, 0.563, 0.609, 0.656, 0.703, 0.750, 0.797, 0.844, 0.891, 0.938, 0.984, 1.031, 1.078, 1.125, 1.172, 1.219, 1.266, 1.313, 1.359, 1.406, 1.453, -1.500, -1.453, -1.406, -1.359, -1.313, -1.266, -1.219, -1.172, -1.125, -1.078, -1.031, -0.984, -0.938, -0.891, -0.844, -0.797, -0.750, -0.703, -0.656, -0.609, -0.563, -0.516, -0.469, -0.422, -0.375, -0.328, -0.281, -0.234, -0.188, -0.141, -0.094, -0.047};

 
int main() {
    wifly.init(); //Use DHCP
    while (!wifly.connect());
    led1=1;
    Websocket ws("ws://192.168.21.104:8080");
    while (!ws.connect());
    led1=2;
 
   
    //gyro
    int gyro_x = 0, gyro_y = 0, gyro_z = 0, temp = 0;
    //Set highest bandwidth.
    gyro.setLpBandwidth(LPFBW_42HZ);
    //3Axio
    Acc.init();             // Initialization
    
    while (1) {
        char data[256];
        wait(0.1f);
        
        //gyro
        gyro_x = gyro.getGyroX();
        gyro_y = gyro.getGyroY();
        gyro_z = gyro.getGyroZ();
        temp = gyro.getTemperature();
        
        //3-Axio
        float x=0, y=0, z=0;
        float ax=0, ay=0, az=0;
        
        Acc.read_Tilt(&x, &y, &z);                                  // Read the acceleration                    
       
        ax = G_VALUE[Acc.read_x()];
        ay = G_VALUE[Acc.read_y()];
        az = G_VALUE[Acc.read_z()];
        
        
        
        //websocket send data
        sprintf( data , "{ \"x\": %d, \"y\": %d, \"z\": %d , \"ax\": %f, \"ay\": %f, \"az\": %f\n}",  gyro_x, gyro_y, gyro_z ,ax,ay,az);
        ws.send(data);

    }
}

