#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"
#include "ITG3200.h"
 

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p13, p14, p19, p26, "WWNet", "mmmmmmmm", WPA);
DigitalOut led1(LED1);
ITG3200 gyro(p9, p10, 0x68);


 
int main() {
    wifly.init(); //Use DHCP
    //wifly.init("192.168.21.33","255.255.255.0","192.168.21.2");
    while (!wifly.connect());
    led1=1;
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    Websocket ws("ws://sockets.mbed.org/ws/mbedschool/viewer");
    //Websocket ws("ws://192.168.199.159:8888");
    while (!ws.connect());
    led1=2;
 
   
    int x = 0, y = 0, z = 0, temp = 0;
    //Set highest bandwidth.
    gyro.setLpBandwidth(LPFBW_42HZ);
 
    while (1) {
        char data[256];
        wait(0.1f);
        x = gyro.getGyroX();
        y = gyro.getGyroY();
        z = gyro.getGyroZ();
        temp = gyro.getTemperature();
  
        printf("Temp: %d, X: %d, Y: %d, Z: %d\n", temp, x, y, z);
        sprintf( data , "Temp: %d, X: %d, Y: %d, Z: %d\n", temp, x, y, z );
        ws.send(data);
        
        //wait(1.0);
    }
}
