#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"





/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p28, p27, p19, p26, "SEEED-MKT", "depot0510", WPA);
DigitalOut led1(LED1);
Serial gps(p9, p10);
char buffer[65];                  
int count=0; 
void clearBufferArray()                     // function to clear buffer array
{
    for (int i=0; i<count;i++)
    { buffer[i]=NULL;}                      // clear all index of array with command NULL
}
 
int main() {
    //wifly.init(); //Use DHCP
    wifly.init("192.168.21.45","255.255.255.0","192.168.21.2");
    while (!wifly.connect());
    led1=1;
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    Websocket ws("ws://192.168.21.123:8888");
    while (!ws.connect());
    led1=2;
        
    count=0;   
    while (1) {
        char locatedata[256];
                
        while(gps.readable ())               // reading data into char array
        {
            char data[1];          
            data[0] = gps.getc();

            ws.send(data);            
        }
     //   ws.send(buffer);                // if no data transmission ends, write buffer to hardware serial port
        clearBufferArray();                         // call clearBufferArray function to clear the storaged data from the array
        count = 0; 
                 
        wait(1.0);
    }
}
