#include "mbed.h"
 
Serial pc(USBTX, USBRX);
InterruptIn probe(p19);
DigitalOut led(LED1);

Timer timer;
Ticker ticker;

uint32_t low_time = 0;

void down();
void up();

void tick()
{
    pc.printf("%d us, %f %%\r\n", low_time, low_time / (30.0 * 1000000));
    low_time = 0;
}
 
void down()
{
    probe.rise(&up);
    led = 0;
    timer.start();
}

void up()
{
    led = 1;
    timer.stop();
    probe.fall(&down);
    
    low_time += timer.read_us();
    timer.reset();
}
 
int main()
{
    pc.baud(115200);
    pc.printf("Dust Sensor test\r\n");
    probe.fall(&down);
    ticker.attach(tick, 30);    
}