#include "mbed.h"

InterruptIn accelerateur(p15);
InterruptIn ralentisseur(p18);
PwmOut moteur1(p21);
PwmOut moteur2(p22);
float pwm;
Ticker flipper; // On crée un ticker que l'on associe

void regulateur ()
{
    if (accelerateur==0) {
        if (pwm<1.0) {
            pwm=pwm+0.01; // on incrémente la valeur de pwm
            moteur1=pwm;  // et on l'impose au moteur 1
            wait_ms(20); // on crée un temps d'attente avant la prochaine incrémentation
        }
    }
    if(ralentisseur==0) {
        if (pwm>0.0) {
            pwm=pwm-0.01;
            moteur1=pwm;
            wait_ms(5);
        }
    }
    if((pwm>0.0) && (accelerateur==1) && (ralentisseur==1)) { // si aucun des 2 boutons n'est enclenché et que la vitesse est non nulle
        pwm=pwm-0.01;     // alors la roue libre se met en place et décremente la valeur de la vitesse 
        moteur1=pwm;
        wait_ms(40);
    }
}

int main ()
{
    flipper.attach(&regulateur,0.2); // la fonction régulateur est appelée par le ticker toutes les 0.2s
    while(1)
        {}
}