#include "mbed.h"

InterruptIn accelerateur(p15); // Nos 2 boutons qui serviront d'interruptions (accéleration, ralentissement)
InterruptIn ralentisseur(p18);

PwmOut moteur1(p21); // On utilisera que le moteur1
PwmOut moteur2(p22);
float pwm; // On initialise une variable flottante pwm

void regulateur () // On crée une nouvelle fonction : régulateur

{
    if (accelerateur==0) {// Si le bouton accéllerateur est enclenché
        if (pwm<1.0)        // et si la vitesse du moteur n'est pas à son maximum
            pwm=pwm+0.05;      // alors le moteur voit sa vitesse augmentée de 5%
        moteur1=pwm;
    }
    if(ralentisseur==0) { // A l'inverse si la touche ralentisseur est enclenché et que
        if (pwm>0.0)        // le moteur n'a pas une vitesse nulle
            pwm=pwm-0.2;    // alors le moteur voit sa vitesse baissée de 20% à chaque appui
        moteur1=pwm;
    }
}

int main ()
{
    accelerateur.fall(&regulateur); // La fonction régulateur intervient lorsqu'un des 2 boutons est enclenché
    ralentisseur.fall(&regulateur);
    while(1)
        {}
}