#include "mbed.h"
#include "lib_LCD_i2c_SPTLYI.h"

Timer t;
Timeout flipper;    // Pour cet exercice nous utiliserons simplement un TimeOut en plus c'est à dire qu'elle va appeler une fonction
InterruptIn button(p15);    // après un temps donné
InterruptIn button2(p17);
InterruptIn button3(p18);
LCD_I2C LCD(p28,p27,p26,0x7C);

int timer=0;
int min=0;
int timer_ms = 0;

void fonction_demarrer()
{
    t.start();
}
void fonction_reset()
{
    t.reset();
}
void fonction_arreter()
{
    t.stop();
    flipper.attach(&fonction_reset, 2.0);       // Dans la fonction arreter, si la fonction est active plus de 2s alors la fonction reset
                                                // est appelée et le timer est reset.
}

int main()
{
    button.fall(&fonction_demarrer);
    button3.fall(&fonction_arreter);

    button2.fall(&fonction_reset);
    while(1) {
        LCD.clear();
        LCD.set_position_cursor(0,0);
        LCD.print(min);
        if(min>=60) {
            t.reset();
        }
        LCD.set_position_cursor(2,0);
        LCD.print(":");
        LCD.set_position_cursor(5,0);
        LCD.print(":");
        LCD.set_position_cursor(3,0);
        timer =  t.read();
        LCD.print(timer);
        if (timer>=60) {
            t.reset();
            LCD.set_position_cursor(4,0);
            LCD.print(" ");
            min=min+1;
        }
        LCD.set_position_cursor(6,0);
        timer_ms =  t.read_ms();
        LCD.print(timer_ms%1000);
        wait_ms(10);
    }
}