#include "mbed.h"

#include "lib_LCD_i2c_SPTLYI.h"
Timer t;    // On initialise notre timer
InterruptIn button(p15);    // On initialise nos interruptions qui seront ici nos boutons poussoirs p15,p17 et p18
InterruptIn button2(p17);
InterruptIn button3(p18);
LCD_I2C LCD(p28,p27,p26,0x7C);  // On initialise la bibliothèque LCD

int timer=0;
int min=0;      // Le timer, le temps en min et en ms sont initialisés à 0
int timer_ms = 0;

void fonction_demarrer()        // On créer 3 fonctions d'interruptions :
{
    t.start();                  // La f fonction démarrer dans laquelle on fait démarrer le timer
}
void fonction_arreter()
{
    t.stop();                   // La fonction arrêter pour laquelle le timer s'arrête

}
void fonction_reset()
{
    t.reset();                  // Et la fonction reset pour alquelle le timer se réinitialise à 0
}
int main()
{
    button.fall(&fonction_demarrer);    // Dans le programme principale on crée nos interruptions lorsque le bouton 1 est enclenché
    button3.fall(&fonction_arreter);    // la fonction démarrer est appelé de même pour les fonctions arrêter et reset pour
    button2.fall(&fonction_reset);      // les boutons poussoirs 2 et 3 respectivement.
    while(1) {
        LCD.clear();
        LCD.set_position_cursor(0,0);
        LCD.print(min);                   // Lorsque le timer a démarré, on place les curseurs pour qu'il nous affiche les min
        if(min>=60) {
            t.reset();                      // Si le timer dépasse l'heure cad plus de 60 min, il se reset
        }
        LCD.set_position_cursor(2,0);
        LCD.print(":");                     // on sépare les minutes des secondes et les secondes des millisecondes grâce à des :
        LCD.set_position_cursor(5,0);
        LCD.print(":");
        LCD.set_position_cursor(3,0);
        timer =  t.read();                  // on entre la valeur des secondes dans timer et on demande d'écrire timer sur l'écran LCD
        LCD.print(timer);
        if (timer>=60) {
            t.reset();                      // Si la valeur en secondes dépasse les 60 on incrémente les minutes de 1
            LCD.set_position_cursor(4,0);
            LCD.print(" ");
            min=min+1;
        }
        LCD.set_position_cursor(6,0);
        timer_ms =  t.read_ms();        // On entre le valeur en millisecondes dans timer_ms puis on l'écrit sur l'écran LCD
        LCD.print(timer_ms%1000);       // On crée un modulo 1000 pour les millisecondes ce qui permettra de garder une valeur comprise entre 0 et 999
        wait_ms(10);        //  L'affichage se fait toutes les 10ms
    }
}