#ifndef DEF_lib_SHT11_H
#define DEF_lib_SHT11_H

#include "mbed.h"


class SHT11 : public Ticker
{
public:
    SHT11(PinName pin_DATA, PinName pin_SCK, float T_C_mesure);

    float lire_T(void);
    float lire_H(void);
    void lire_T_H(float *, float *);
    void changer_timer_cycle(float new_Temps_cycle_mesure);
    void init(void);
    void desactiver(void);
    
private:
    
    void start(void);
    void gestion_HT(void);
    void demande_mesure(short octet_de_commande);
    void mesure_T(void);
    void mesure_H(void);
    void mesure_T_H(void);
    void reception_mesure_T(void);
    void reception_mesure_H(void);
    void calcul_Temperature_Humidite(void);

    DigitalInOut DATA_HT;
    DigitalOut SCK_HT;
    Ticker Timer_cycle_mesure;

    unsigned int Temperature;
    unsigned int Humidite;
    unsigned etat_sht11;
    unsigned etat_cycle;
    float Temperature_mesuree;
    float Humidite_mesuree;
    float Temps_cycle_mesure;
};

#endif

