#include "mbed.h"
#include "AQM1602.h"
#include "SDFileSystem.h"
#include "ds3231.h"
#define ESC 0x1B

//-------LCD Setting------
I2C i2c(PB_7, PB_6);//sda,scl
AQM1602 lcd(i2c);

//-------SD Setting-------
SDFileSystem sd(PE_6, PE_5, PE_2, PE_3 , "sd");//mosi.miso,sck,cs,mount  

//------AE Data(SPI)------
SPI spi(PF_9, PF_8, PF_7); // mosi, miso, sclk
DigitalOut IO_CS(PF_13);

//-----------RTC----------
void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member);
void get_user_input(char* message, uint8_t min, uint8_t max, bool* member);

//--------IO Enable--------
DigitalOut IO_Enable(PD_9);

//-----AE Interrupt--------
InterruptIn DE(PG_8);//IO10  Analog Bord IO9

//---------------------------------
// HPF Setting  
// 0:THRU 1:30kHz 2:100kHz 3:200kHz
//---------------------------------
BusInOut IO_HPF(PD_10,PD_14);

//---------------------------------
// Gain Setting  
// 0:0dB 1:10dB 2:20dB 3:30dB 4:40dB
//---------------------------------
BusInOut IO_Gain(PD_15,PE_14,PE_15,PG_2);//IO1,IO2,IO3  Analog Bord IO0,IO1,IO2,IO3

//-----I/O Setting--------
DigitalOut IO5(PG_3);//Analog Bord IO4
DigitalOut IO6(PG_4);//Analog Bord IO5
DigitalOut IO7(PG_5);//Analog Bord IO6
DigitalOut IO8(PG_6);//Analog Bord IO7
DigitalOut IO9(PG_7);//Analog Bord IO8

//-----------Alarm---------
DigitalOut Ararm(PF_14);
//---------Encoder---------
DigitalIn Encorder_SW(PA_15);  //SW
//DigitalIn Encorder_A(PD_0);  //A
DigitalIn Encorder_B(PD_1);  //B
InterruptIn Encorder_A(PD_0);  //A


//-----Serial Setting------
Serial rs232 (PB_10, PB_11);

uint16_t WaveData1[32768];  
uint16_t WaveData2[32768];
int DataEnable;
int EncAEnable;
int EncCount;

//------AE Interrupt Main------
void GetData(){
    DataEnable=1;
}

//-------Encoder Interrupt------
void EncCheck(){
    EncAEnable=1;
    //wait_ms(2);
}
 
void menu1(){
    switch(EncCount){
        case(1):
            lcd.locate(0,0);lcd.printf("  1.Mode       ");
            break;
        case(2):
            lcd.locate(0,0);lcd.printf("  2.Gain       ");
            break;
        case(3):
            lcd.locate(0,0);lcd.printf("  3.HPF        ");                                  
            break;                                       
        case(4):
            lcd.locate(0,0);lcd.printf("  4.Interval   ");                                      
            break;  
        case(5):
            lcd.locate(0,0);lcd.printf("  5.EXIT       ");                                      
            break;
    }  
} 
 
void menu2(){
    switch(EncCount){
        case(1):
            lcd.locate(0,0);lcd.printf("  Gain=0dB    ");
            break;
        case(2):
            lcd.locate(0,0);lcd.printf("  Gain=10dB   ");
            break;
        case(3):
            lcd.locate(0,0);lcd.printf("  Gain=20dB   ");                                        
            break;                                       
        case(4):
            lcd.locate(0,0);lcd.printf("  Gain=30dB   ");                                       
            break;  
        case(5):
            lcd.locate(0,0);lcd.printf("  Gain=40dB   ");                                    
            break;
        case(6):
            lcd.locate(0,0);lcd.printf("  EXIT        ");                                    
            break;
    }
} 
 
int main()
{  
    //------Serial Setting------
    rs232.baud(230400);
    //---------Init LCD---------
    lcd.init();
    //---Mount the filesystem---
    sd.mount();   
    //--------IO Power ON-------
    wait_ms(100);    
    IO_Enable=1;
    //------Initial Display-----
    lcd.clear();
    lcd.setDispFlag(1,0,0);  //Cursole消す   
    //-------SPI Setting-------
    IO_CS = 1;
    spi.format(16,0);
    spi.frequency(1000000);
    
    //-----------------------------SD test------------------------------
    lcd.clear();
    lcd.locate(0,0);
    lcd.printf("WR to SD card   ");
    wait_ms(100);

    //----------SD書き込み試験--------    
    FILE *fp = fopen("/sd/sdtest.txt", "w");   // 追加書き込み
   
    if (fp != NULL)
    {
        fprintf(fp, "SD カードのテストファイルです．\r\n");
        fclose(fp);
        
        lcd.locate(0,0);
        lcd.printf(" SDWR SUCCESS! ");
        wait_ms(100);
    }
    else{
        lcd.clear();
        lcd.locate(0,0);
        lcd.printf(" SD FAILED!    ");
        while(1);
    }
      
    //----------SD読み出し試験--------
    lcd.locate(0,0);
    lcd.printf("Reading from SD ");
    fp = fopen("/sd/sdtest.txt", "r");
    if (fp != NULL)
    {
        char str[256];
        while (fgets(str, 256, fp) != NULL)
            //rs232.printf("%s", str);
        fclose(fp);
        lcd.locate(0,0);
        lcd.printf(" SDRD SUCCESS! ");
        wait_ms(100);
    }
    else{
        lcd.clear();
        lcd.locate(0,0);
        lcd.printf(" SD FAILED!   ");
        while(1);
    }

    //--------チェック結果の表示--------        
    lcd.locate(0,0);   
    lcd.printf(" CHECK All OK! ");        
    wait(1); 
    lcd.locate(0,0);
    lcd.printf(" FUJIMURA CREST");     
    lcd.locate(0,1);
    lcd.printf(" FCAS-M101    ");    
    wait(1);        
    
    //-----------------------------RTCセッティング------------------------------
    //Ds3231 rtc(PB_7, PB_6); 
    Ds3231 rtc(PF_0, PF_1);             
    time_t epoch_time;

    //default, use bit masks in ds3231.h for desired operation
    ds3231_cntl_stat_t rtc_control_status = {0,0};    
    ds3231_time_t rtc_time;
    ds3231_calendar_t rtc_calendar;

//******************************* メインルーチン *******************************
    uint16_t spi_data[16]; 
    uint16_t Amplitude;
    char TxDataChar1,TxDataChar2; 
    char moji[36];
    uint32_t  n,i;     
    int Gain;            //Gain
    int StartFlag=1;
    int menuFlag =1;
    int EncCount2;

    //---------BUS（ゲイン）の設定-----------
    IO_Gain.output();
    IO_Gain=2;

    //---------------HPF 30kHz------------    
    IO_HPF.output();
    IO_HPF=0;  

    //---------------割り込みON------------    
    DE.rise(&GetData); 
    Encorder_A.rise(&EncCheck);




    while(1) {
        //----------------------------------------------------------------            
        while(StartFlag){
            lcd.locate(0,0);
            lcd.printf(" Wait START!   ");  
            lcd.locate(0,1);
            lcd.printf(" Menu>Push long");    
                
            if(Encorder_SW==0){
                wait_ms(300);
                StartFlag=0;
                //----------menu選択--------   
                if(Encorder_SW==0){ 
                    StartFlag=1;                    
                    lcd.clear();
                    lcd.locate(0,0);
                    lcd.printf(" -----Menu-----   ");
                    wait_ms(500);  
                      
                    //---------------------Select menu-----------------   
                    while(menuFlag){
                        //----------Encoder Check--------                          
                        if(EncAEnable==1){
                            wait_us(100);
                            if(Encorder_B==0){
                                EncCount=EncCount+1;
                            }else{
                                if(EncCount!=0){
                                    EncCount=EncCount-1;                                      
                                }
                            }                                    
                            menu1();
                            EncAEnable=0; 
                        }                                                                            
                        if(EncCount>5){
                            EncCount=5;
                        }
                        //----------Encoder End--------  
                                          
                        if(Encorder_SW==0){
                            if(EncCount==2){
                                lcd.locate(0,0);
                                lcd.printf(" Select Gain   ");
                                EncCount=1;
                                while(1){     
                                    //----------Encoder Check--------                          
                                    if(EncAEnable==1){
                                        wait_us(100);
                                        if(Encorder_B==0){
                                            EncCount=EncCount+1;
                                            if(EncCount>6){
                                                EncCount=6;
                                            }
                                        }else{
                                            if(EncCount!=0){
                                                    EncCount=EncCount-1;
                                            }
                                        }                                    
                                        menu2();
                                        EncAEnable=0; 
                                    }                                                                            
                                    //----------Encoder End--------
                                    if(Encorder_SW==0){
                                        if(EncCount!=6){
                                            switch(EncCount){                                          
                                                case(1):
                                                    IO_Gain=0;
                                                    lcd.locate(0,0);lcd.printf(" Set Gain=0dB  ");
                                                    break;
                                                case(2):
                                                    IO_Gain=1;
                                                    lcd.locate(0,0);lcd.printf(" Set Gain=10dB ");
                                                    break;
                                                case(3):
                                                    IO_Gain=2;
                                                    lcd.locate(0,0);lcd.printf(" Set Gain=20dB ");
                                                    break;
                                                case(4):
                                                    IO_Gain=3;
                                                    lcd.locate(0,0);lcd.printf(" Set Gain=30dB ");
                                                    break;  
                                                case(5):
                                                    IO_Gain=4;
                                                    lcd.locate(0,0);lcd.printf(" Set Gain=40dB ");
                                                    break;   
                                            }                                                                                                                                                     
                                        }                         
                                        if(EncCount==6){     //menu終了   
                                            menuFlag=0;
                                            StartFlag=1;
                                            wait_ms(50);
                                            break;
                                        }
                                    }     
                                }                                                          
                            } 
                                                                         
                            if(EncCount==5){     //menu終了
                                menuFlag=0;
                                StartFlag=1;
                                wait_ms(50);
                            }
                        }                           
                    }
                    //-----------------Select menu End------------------   
                }          
                menuFlag=1;
                EncCount=0;    
            }
        }
        //----------------------------------------------------------------


        if(n==0){
            //----------データ保存SDオープン--------    
            //new epoch time fx
            epoch_time = rtc.get_epoch();            
            strftime(moji, 32, "/sd/%m%d_%I%M%S.csv", localtime(&epoch_time));
            fp  = fopen(moji, "a+");   // 追加書き込み
        }   

        if(DataEnable==1){
            IO_CS=0;
            spi_data[0] = spi.write(Gain);
            IO_CS=1;  
            
            TxDataChar1=(spi_data[0] & 0x007f); //0-6 
            TxDataChar2=(spi_data[0] & 0xff80)>>7;        //7-12
            //SDカードへ包絡線検波波形データ書き込み
            Amplitude=TxDataChar2*128+TxDataChar1;
            
            if(n==0){
                lcd.clear();
                lcd.locate(0,0);
                lcd.printf(" ----START----");     
            }
                
            if(n<4096){
                WaveData1[n]=Amplitude;    
            }
  
            DataEnable=0;
        n=n+1;
        }

        if(n==4096){            
            //new epoch time fx
            epoch_time = rtc.get_epoch();
                
            strftime(moji, 32, "%m/%d %I:%M:%S \r\n", localtime(&epoch_time));
            fprintf(fp, moji);

            lcd.locate(0,0);
            lcd.printf(" --Save Data-- ");                    
            
            while(i<4096){
                if (fp != NULL){
                    sprintf(moji,"%d\r\n",WaveData1[i]);
                    fprintf(fp, moji);
                }else{
                    lcd.clear();
                    lcd.locate(0,0);
                    lcd.printf(" SD FAILED!     ");
                    while(1);
                }
                 i=i+1;
            }    
            fclose(fp);
            lcd.locate(0,0);
            lcd.printf("Data Save END!");
            wait_ms(500);
            n=0;
            i=0;
            StartFlag=1;         
        }
        

    }


        
/*    
    rtc.set_cntl_stat_reg(rtc_control_status);

    //get day from user
    get_user_input("\n\rPlease enter day of week, 1 for Sunday (1-7): ", 1,
                    7, &rtc_calendar.day);

    //get day of month from user
    get_user_input("\n\rPlease enter day of month (1-31): ", 1, 31, 
                    &rtc_calendar.date);

    //get month from user
    get_user_input("\n\rPlease enter the month, 1 for January (1-12): ", 1, 
                    12, &rtc_calendar.month);

    //get year from user
    get_user_input("\n\rPlease enter the year (0-99): ",0, 99, 
                    &rtc_calendar.year);
           
    //Get time mode
    get_user_input("\n\rWhat time mode? 1 for 12hr 0 for 24hr: ", 0, 1, 
                   &rtc_time.mode);  
    
    if(rtc_time.mode)
    {
        //Get AM/PM status
        get_user_input("\n\rIs it AM or PM? 0 for AM 1 for PM: ", 0, 1, 
                       &rtc_time.am_pm);  
        //Get hour from user
        get_user_input("\n\rPlease enter the hour (1-12): ", 1, 12, 
                       &rtc_time.hours);
    }
    else
    {
        //Get hour from user
        get_user_input("\n\rPlease enter the hour (0-23): ", 0, 23, 
                       &rtc_time.hours);
    }
     
    //Get minutes from user
    get_user_input("\n\rPlease enter the minute (0-59): ", 0, 59, 
                   &rtc_time.minutes);
    
    
    //Get seconds from user
    get_user_input("\n\rPlease enter the second (0-59): ", 0, 59, 
                   &rtc_time.seconds);
    
    
    
    //Set the time, uses inverted logic for return value
    if(rtc.set_time(rtc_time))
    {
        printf("\n\rrtc.set_time failed!!\n\r");
        exit(0);
    }
    

    
    //Set the calendar, uses inverted logic for return value
    if(rtc.set_calendar(rtc_calendar))
    {
        rs232.printf("\n\rrtc.set_calendar failed!!\n\r");
        exit(0);
    }
*/    
    char buffer[32];

    
    while(1){   
    
        rs232.printf("%c[2J", ESC); //clear screen
        rs232.printf("%c[H", ESC); //move cursor to Home
        
        //new epoch time fx
        epoch_time = rtc.get_epoch();

                
        //lcd.printf("\n\r%s", ctime(&epoch_time));
        rs232.printf("\n\r%s", ctime(&epoch_time));
         
        //strftime(buffer, 32, "%I:%M %p\n\r", localtime(&epoch_time));
        
        strftime(buffer, 32, "%m/%d %I:%M:%S", localtime(&epoch_time));
        lcd.locate(0,1);
        lcd.printf("%s", buffer);
        //rs232.printf("%s", buffer);        
                
        wait(1);
    }  //loop 



}



/**********************************************************************
* Function: get_user_input() 
* Parameters: message - user prompt
*             min - minimum value of input
*             max - maximum value of input
*             member - pointer to struct member              
* Returns: none
*
* Description: get time/date input from user
*
**********************************************************************/
void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member)
{
    uint32_t temp;

    do
    {
        rs232.printf("\n\r%s", message);
        
        //for some reason mbed doesn't like a pointer to a member in scanf
        //term.scanf("%d", member); works with gcc on RPi
        rs232.scanf("%d", &temp);
        
        *member = temp;
       
        if((*(member)< min) || (*(member) > max))
        {
            rs232.printf("\n\rERROR-RTI");
        }
    }
    while((*(member) < min) || (*(member) > max));
}


void get_user_input(char* message, uint8_t min, uint8_t max, bool* member)
{
    uint32_t temp;

    do
    {
        rs232.printf("\n\r%s", message);
        
        //for some reason mbed doesn't like a pointer to a member in scanf
        //term.scanf("%d", member); works with gcc on RPi
        rs232.scanf("%d", &temp);
        
        *member = temp;
       
        if((*(member)< min) || (*(member) > max))
        {
            rs232.printf("\n\rERROR-RTI");
        }
    }
    while((*(member) < min) || (*(member) > max));
}



