#include "classSpring.h"
#include "myVectorClass.h"

//---------------------------------------------------------------------
spring::spring(){
    massA = NULL;
    massB = NULL;
}

//---------------------------------------------------------------------
void spring::update(){
    if ((massA == NULL) || (massB == NULL)){
        return;
    }
    
    vector2Df pta = massA->pos;
    vector2Df ptb = massB->pos;
    
    float theirDistance = (pta - ptb).length();
    float springForce = (springiness * (distance - theirDistance));
    vector2Df frcToAdd = (pta-ptb).normalize() * springForce;
    
    massA->addForce(frcToAdd);
    massB->addForce(-frcToAdd);
    //massA->totalForce.x+=frcToAdd.x;massA->totalForce.y+=frcToAdd.y;
    //massB->totalForce.x-=frcToAdd.x;massB->totalForce.y-=frcToAdd.y;
}

void spring::assymetricUpdate(){ // only second mass suffers a force
    if ((massA == NULL) || (massB == NULL)){
        return;
    }
    
    vector2Df pta = massA->pos;
    vector2Df ptb = massB->pos;
    
    float theirDistance = (pta - ptb).length();
    float springForce = (springiness * (distance - theirDistance));
    vector2Df frcToAdd = (pta-ptb).normalize() * springForce;
    
    //massA->addForce(frcToAdd);
    massB->addForce(-frcToAdd);
    //massA->totalForce.x+=frcToAdd.x;massA->totalForce.y+=frcToAdd.y;
    //massB->totalForce.x-=frcToAdd.x;massB->totalForce.y-=frcToAdd.y;
}
