#ifndef blobConf_h
#define blobConf_h

// include all kind of spots classes (childs of soundSpot)
#include "elasticLoop.h"
#include "rigidLoop.h"
#include "hardwareIO.h" // this is in fact only to get to know the initial position of the spots, as well as the mirror limits to set the bounding box for the blobs

#include <vector>
//#include <deque>; // using a deque instead of a vector can have advantanges in terms of memory (deque can handle fragmented memory), BUT IS SLOWER.
using namespace std;

// This is for the SKIN GAMES project, in which not only each blob object has behaviour of its own, but the blobs can interact in different ways; hence the update
// method cannot be just "update all the blobs": 
enum configType {ONE_ELASTIC_FOLLOWING, ONE_ELASTIC_MOUTH, ONE_ELASTIC_MOUTH_SMALL, 
                 ONE_TRACKING_SPOT, ONE_TRACKING_SPOT_DOT,
                 BOUNCING_SPOTS, LORENTZ_SPOTS, FOLLOWING_SPOTS, 
                 AIR_HOCKEY_GAME, CIRCULAR_PONG_GAME, FISH_NET_GAME, VERTICAL_PINBALL_GAME, PAC_MAN_GAME,
                 RAIN_MODE};

class blobConfig {
public:

    //========== Methods =============
    blobConfig(); // overaloded constructor
    blobConfig(configType cftype, unsigned char numspots=1) { initConfig(cftype, numspots);}; // overaloded constructor with parameters
    ~blobConfig();

    void initConfig(configType myConfigType,  int numblobs=1);

    void clearConfig(); // actually delete every element of the config (note: the blobArray is a vector of POINTERS, it is not enought to do blobArray.clear()).

    void processSensedData();

    void allKill(); // this put all the blobs in "dead" mode, meaning that neither rendering nor update is done (but they are not deleted).
    void allAlive();

    void allStandBy(); //NO update, but rendering may be done (they are "frozen" in their positions)
    void allResume();

    void allInvisible(); // blobs are invisible, but they may continue to evolve (call to update)
    void allVisible();
    
    void allSetColor(unsigned char c); 
    void allSetGreen(unsigned char c);
    void allSetBlue(unsigned char c); 
    void randomizeAllColors(); 

    void update(); // update dynamics
    void draw();   // draw in the LaserSensingTrajectory object (lsdTrajectory) of each blob, using the openGL laser rendering (not yet done).

    void printParameters(); // on serial port (for calibration)
    
    void sendConfData(); // send OSC data for all the blobs

    void computeBoundingBox();

    // ========= Template spots from which to create multi-spot configurations: =====================
    void addOneElasticLoopRelax(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticLoopContract(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticLoopContractCentral(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticLoopContractCentralFast(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticContourFollowing(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticContourFollowingFAST(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneElasticBouncing(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(1,1));

    void addOneRigidLoopBouncing(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(2,2));
    void addOneRigidLoopBouncingGravity(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(2,2));
    void addOneRigidLoopLorentz(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(2,2));
    void addOneRigidLoopAirHockey(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidLoopFollowing(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidLoopTest(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidTrackingSpot(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidTrackingSpotDot(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidLoopPacman(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));
    void addOneRigidLoopGhost(vector2Df initpos=vector2Df(CENTER_AD_MIRROR_X, CENTER_AD_MIRROR_Y), vector2Df initspeed=vector2Df(0,0));

    //========== Variables =============
    configType myConfigType;
    
    // I use an array (actually a vector) of POINTERS of polymorphic class soundSpot with virtual methods (this way we can access polymorphic methods - of children - with a pointer)
    // BUT ATTENTION when clearing the vector: instantiated objects must be DELETED before.
    vector<soundSpot*> blobArray;
    int numBlobs;// this is just equal to blobArray.size()
};


#endif