#include "soundSpot.h"

// SHOULD NOT BE HERE: (only because I am using serial princ pc object)
#include "hardwareIO.h"

// Constructor:
soundSpot::soundSpot() { // by default, the child constructor call the parameterless default constructor (we could force another by doing: soundSpot::soundSpot : LivingSpot (params...) { ..}
 
// DEFAULT sending mode will be all off:
stopAllSending();
resetAllSendingModes();

initCommonVariables();

// initialize timer for sending OSC data:
periodSendingData=25;// by default, we send the data every 25 ms. Note: the "data" to send will of course depend on the kind of blob. That will be therefore re-set when 
// instantiating the kind of blob. 
measureSendPeriod.start();
}

// IMPORTANT: the destructor of the base class is virtual, but it won't be implemented with the same name in the child class; therefore, it 
// must be implemented in the base class (and it will be called when using delete of the child, first the delete child, then delete base)
soundSpot::~soundSpot() {
}
    
void soundSpot::printParameters() {
    // first show common parameters, then call the virtual method:
    pc.printf("Mirror delay :%d\n", displaySensingBuffer.delayMirrorSamples);
    pc.printf("Angle correction force :%f\n", angleCorrectionForceLoop);
    pc.printf("Thresholding mode :%d\n", displaySensingBuffer.modeThreshold);
    pc.printf("Min Contrast Ratio :%f / Current Contrast: %f\n", displaySensingBuffer.min_contrast_ratio, 1.0*displaySensingBuffer.maxI/displaySensingBuffer.minI);
    pc.printf("Threshold Factor: %f\n", displaySensingBuffer.threshold_factor);
    pc.printf("Min Acceptable Intensity :%f\n", displaySensingBuffer.min_acceptable_intensity);
    pc.printf("Current Max / Min Intensity: %d / %d\n", displaySensingBuffer.maxI, displaySensingBuffer.minI, displaySensingBuffer.maxI/displaySensingBuffer.minI);
    this->showChildParameters();
    }    
    
void soundSpot::setColor(unsigned char c) {
    blobColor=0x07&c; // we will use the first three bits to set the RGB colors.
}

void soundSpot::setGreenColor(unsigned char c) {
// this set/reset the green bit only:
   if (c>0) blobColor=blobColor|0x2; //meaning second bit to 1
   else blobColor=blobColor&0x5; // meaning second bit to 0
}

void soundSpot::setBlueColor(unsigned char c) {
// this set/reset the green bit only:
   if (c>0) blobColor=blobColor|0x1; //meaning first bit to 1
   else blobColor=blobColor&0x6; // meaning first bit to 0
}

 void soundSpot::addAngleCorrection(float _moreAngleCorrection) {
     angleCorrectionForceLoop+=_moreAngleCorrection;
     }
void soundSpot::setAngleCorrection(float _angleCorrection) {
     angleCorrectionForceLoop=_angleCorrection;
     }

void soundSpot::initCommonVariables() {
   firstTimeNoTouch=true;
    // randomForce.set(1,0);// first time there won't be any force, or random force
    // randomForce=randomForce.getRotatedDeg(1.0*(rand()%360));
    // randomForce.normalize();

    noTouchedCounter=0;
    wallCounter=0;
    blobWallCollision=false;
    //slidingDirection=true; //  (will change when touching wall)
    
    gravity.set(0,0);
    
     render=true;
     standByMode=true; // ALWAYS START IN STANDBY MODE
}

 void soundSpot::resetAllSendingModes() {
  // RESET SENDING DATA:
  sendingOnlyWhenTouch=false;
 // (a) anchor mass data: 
  sendingAnchorPosition=false;
  sendingAnchorForce=false; // this is the total force on the anchor mass, not just the recentering force
  sendingAnchorTouchWall=false;
  // (b) data from blob points:
  sendingLoopPositions=false;
  sendingLoopForces=false;// this is not just the forces from light, but all the forces in each particle
  sendingLoopForcesLight=false;// forces only from light
  sendingLoopRegions=false; // from this we can detect "hits"
  sendingLoopTouchWall=false;
  // (c) Blob geometry:
  sendingBlobArea=false;
  sendingBlobNormals=false;
  sendingBlobAngles=false; // redundant with sendingBlobNormals, but simplified (only angle of normal)
  sendingKineticEnergy=false;
  // (d) Light sensing statistics: 
  sendingBlobMaxMin=false;
  sendingLightForce=false; // the total light force
  sendingTouched=false;
  // (e) Recentering vector: (note: redundant with sendingLightForce, IF the correction angle is known). 
  sendingRecenteringVector=false;
  sendingRecenteringAngle=false;
  sendingRecenteringNorm=false;
 }

 void soundSpot::stopAllSending() {
 // STOP HARDWARE SENDING MODE (per spot):
 sendSerial=false;
 sendOSC=true;
 }
  
 void soundSpot::sendData(void) { // send data common to all kind of blobs 
    // send common things, such as testing if it is the right time to send data:
   
    if (measureSendPeriod.read_ms()>periodSendingData) {
            measureSendPeriod.stop();
            measureSendPeriod.reset();

          // Send data specific to the derived class:
           if ((sendingOnlyWhenTouch==false)||(blobWallCollision==true)||(displaySensingBuffer.lightTouched==true))
            sendDataSpecific(); // this will depend on the kind of blob
        
            measureSendPeriod.start();
        }
   
} 

