#ifndef RIGID_LOOP
#define RIGID_LOOP

// Include the basic objects to create the loop
#include "soundSpot.h"
#include "classPointMass.h" // this may be used to move the center of the RIGID loop in dynamically "real" ways
#include "classSpring.h"    // same remark than above

using namespace std;

enum RigidLoopMode {SPOT_FOLLOWING,  SPOT_GHOST, SPOT_PACMAN, SPOT_AIR_HOCKEY, SPOT_LORENTZ_FORCE, 
                    SPOT_BOUNCING, SPOT_BOUNCING_FACTOR,
                    SPOT_TEST, SPOT_TRACK, SPOT_TRACK_DOT,
                    EXPLOSION};

class rigidLoop : public soundSpot  {

public:
   
    // Constructor and destructor:
    rigidLoop();
    virtual ~rigidLoop();
    
    // instantiation of the virtual methods of the base class (we don't need to append "virtual", but for clarity I do):
    void createBlob(int _id, RigidLoopMode _rigidBlobMode, vector2Df _initPos, vector2Df _initSpeed);
    virtual void setRegionMotion(float mmix, float mmiy, float mmax, float mmay); // attention: initial position posX and posY should be inside this bounding box...
    virtual void update(vector2Df referencePos);  // update dynamics of the mass loop   
    virtual void draw(void);  // draw the blob (renders on the laser trajectory object lsdTrajectory from the base class, using the openGL laser renderer - not yet done).
    virtual void computeBoundingBox();
    virtual void sendDataSpecific(void);
    virtual void setSpeed(float speed);
    virtual void setSize(float size);
    virtual void speedFactor(float speedfactor);
    virtual void sizeFactor(float sizeFactor);
    
    virtual void explosion(); // not very nice programming style, it should be a MODE instead or something like that. 
    virtual vector2Df getCenter();
    virtual void resetPositionSpeed() {centerMass.setInitialCondition(startCenter, startSpeed);};
    virtual void setPositionSpeed(vector2Df _pos, vector2Df _spe) {centerMass.setInitialCondition(_pos, _spe);};
   
   virtual void showChildParameters();
   
    // methods that are new to this class (not in base class): 
    void initSizeBlob(int _numPoints);
    void createLoopFromScafold(void); // this is much simpler than the elastic blob (here, we only need to add a central mass)
   // void processLoopData(); // not needed, because the loop is rigid.  

    RigidLoopMode updateMode;

 // The number of points in the loop (in this case, is just the number of points in the scaffold, as well as the number of points in the lsdTrajectory)
 // int numPoints; // this belongs to soundSpot base class
    pointMass centerMass; // this is the center of the rigidLoop. Note that it can have mass or not, this will depend on the RigidLoopMode
    float integrationStep;
    
   // The following are common to all blobs:
    // float angleCorrectionForceLoop;
   // vector2D recenteringVectorLoop;
   // float angleRecenteringVector; // auxiliary variables for sending data (for the recenteringVectorLoop)
   // float normRecenteringVector;
    
  // other modes: 
     bool slidingDirection; // for contour following
   
   // numeric parameters:
    float saccadeRadius; 
    
    // THINGS FOR CONTOUR FOLLOWING:
    float saccadeRadius_initial; // this is for SEARCH MODE (remember initial radius)
    bool justSearched;
    
    
    float rotationAngle; // note: in the future, rotation would be done by the openGL-like renderer
    
    float massCenter;
    float dampMotionCenterMass; 
   
    
    float speedContourFollowing; // this is given as a percentage of the radius of the circle
    float factorBouncingForce; // spring force when penetrating on dark zone (used by SPOT_BOUNCING)
    float factorAbsorptionShock; // factor speed damping when bouncing on dark zone (used in SPOT_BOUNCING_FACTOR)
};

#endif