#ifndef MBED_LOCKIN_H
#define MBED_LOCKIN_H

#include "mbed.h"
#include "adc.h"

#define MBEDFREQUENCY 96000 //frequency of the mBed in KHz

//#define I_Volts_SAT 5 // this is 5V (the saturation voltage for the APD+LockIn+ADC, being it the arduino (when in normal mode) or the SPI. This saturation voltage could be different for each mode!?

#define LOCKIN_ADC_PIN      p18 //ADC pin : connect to lockin "output"

#define LOCKIN_REF_PIN      p23 //PWM pin : connect to lockin reference signal.
#define LOCKIN_LASER_PIN    p25 //PWM pin : connect to laser control - note: the red laser by default, but could be a fourth IR laser...
// p21 to p26 are used by the PWM timers even if only 2 pin are connected to the circuit

#define BUFFER_SIZE 15
#define BUFFER_SIZE_MEDIAN 5
#define DELAY_BUFFER_MEDIAN 0


class Lockin {
public:
    // default constructor (untouched!)
    // Lockin();
    
    // initialization of object modes (could have parameters):
    void init();
    
    void initPWM(); //setup the laser and reference signal used by the lockin
    void setPWMFrequency(float freq); //change the shared period of the pwm signals
    void setLaserPhaseShift(float phaseShift); //change the phase shift of the laser (from 0 to 1)
    void setLockinPhaseShift(float phaseShift); //change the phase shift of the lock-in (from 0 to 1)
    //future works: 
    //add function to change frequency or offset with a potentiometer for exemple
    //or scan the best frequency...
    
    void setLaserPower(bool power); //change PWM settings to turn on/off the laser
    
    void setADC_forLockin(int mode); //1 set, 0 reset
    
    unsigned short getSmoothValue(); //return the average of the value stored on the buffer
    unsigned short getLastValue(); //return the last conversion of the ADC
    unsigned short getMedianValue(); //return the median value of the buffer
    //it is just a begining; we can add more complex method for denoising for exemple
    //maybe, needs function to start and stop the lockin
    
    void clearBuffer();
    
    //can be private
    //void catchInterupt(uint32_t value);
    
    //variables
    unsigned short buffer[BUFFER_SIZE];  // does not need to be a float - in fact values are from 0 to 4096 (i.e., 
    //unsigned short int buffer[BUFFER_SIZE]; // this is two bytes (0 to 65535)
    unsigned short orderedBuffer[BUFFER_SIZE_MEDIAN]; // for computation of the MEDIAN value
    int buffer_pos;
    
    float refFrequency;     // frequency of sensing laser and lock-in (in KHz)
    //Phase shift of the pwm signals (from 0 to 1):
    //it corresponds to a percentage of the half of a period
    //(no phase shift ==> 0% / 90deg phase shift ==> 100%)
    float phaseShiftLaser;  // phase shift of the sensing laser 
    float phaseShiftLockin; // phase shift of the lock-in reference
    
    int refFreq; //frequency of the lockin
    int offsetRef; //offset between the laser signal and the lockin reference signal
    int halfRefFreq;
    
private:
    // PWM match register value are saved as private 
    // to avoid computation when turn on/off for exemple
    int _currentMR[6]; 
    

};

extern Lockin lockin;

#endif