#include "mbed.h"
#include "CRotaryEncoder.h"


CRotaryEncoder rotaryEncoder1=CRotaryEncoder(ROTARY_ENCODER1_PINA, ROTARY_ENCODER1_PINB);//pre-instanciation of object lockin with inter-file scope (declared extern in .h file)
CRotaryEncoder rotaryEncoder2=CRotaryEncoder(ROTARY_ENCODER2_PINA, ROTARY_ENCODER2_PINB);//pre-instanciation of object lockin with inter-file scope (declared extern in .h file)

CRotaryEncoder::CRotaryEncoder(PinName pinA, PinName pinB)
{
    m_pinA = new InterruptIn(pinA);
    m_pinA->mode(PullUp); // this is for use in the case of the simple contact based rotary encoder (common is tied to ground)
    m_pinA->rise(this, &CRotaryEncoder::rise);
    m_pinA->fall(this, &CRotaryEncoder::fall);

    m_pinB = new DigitalIn(pinB);
    m_pinB->mode(PullUp); 
    m_position = 0;
    
    newValue=true;
    minValue=0; maxValue=360;
}

CRotaryEncoder::~CRotaryEncoder()
{
    delete m_pinA;
    delete m_pinB;
}
 
 void CRotaryEncoder::SetMinMax(int min, int max) {
     minValue=min;
     maxValue=max;
     }
 
int CRotaryEncoder::Get(void)
{
    return m_position;
}

void CRotaryEncoder::Set(int value)
{
    if (value>maxValue) m_position = maxValue;
    if (value<minValue) m_position = minValue;
    m_position = value;
}

bool CRotaryEncoder::CheckNew()
{
    bool auxValue=newValue;
    newValue=0;
    return(auxValue);
}

void CRotaryEncoder::wrapValue() {
    if (m_position>maxValue) m_position = minValue;
    if (m_position<minValue) m_position = maxValue;
    }

void CRotaryEncoder::fall(void)
{
        if(*m_pinB == 1)
        {
            m_position++;
        }
        else
        {
            m_position--;
        }
        
        wrapValue();
        
        newValue=true;
}

void CRotaryEncoder::rise(void)
{
        if(*m_pinB == 1)
        {
            m_position--;
        }
        else
        {
            m_position++;
        }
        
        wrapValue(); 
        
        newValue=true;
}

