/*
 *  elasticLoop.h
 *  laserBlobPure
 *
 *  Created by CASSINELLI ALVARO on 5/20/11.
 *  Copyright 2011 TOKYO UNIVERSITY. All rights reserved.
 *
 */
 
#ifndef ELASTIC_LOOP
#define ELASTIC_LOOP

// Include the basic objects to create the loop
#include "soundSpot.h"
#include "classPointMass.h"
#include "classSpring.h"

 #include <vector>
 using namespace std;

//#define MAX_NUM_MASSES  50
//#define PI 3.1415926

enum ElasticLoopMode {RELAX, CONTRACT, CONTRACT_CENTRAL, CONTRACT_CENTRAL_FAST, CONTOUR_FOLLOWING, CONTOUR_FOLLOWING_FAST, BOUNCING};

class elasticLoop : public soundSpot  {
    
public:
    
    // Constructor and destructor:
    elasticLoop();
    virtual ~elasticLoop();
    
    // instantiation of the virtual methods of the base class (we don't need to append "virtual", but for clarity I do):
    void createBlob(int _id, ElasticLoopMode _elasticBlobMode, vector2Df _initPos, vector2Df _initSpeed);
    virtual void setRegionMotion(float mmix, float mmiy, float mmax, float mmay); // attention: initial position posX and posY should be inside this bounding box...
    virtual void update(vector2Df referencePos);  // update dynamics of the mass loop   
    virtual void draw(void);  // draw the blob (renders on the laser trajectory object lsdTrajectory from the base class, using the openGL laser renderer - not yet done).
    virtual void computeBoundingBox();
    virtual void sendDataSpecific(void);
    // Some behaviour parameters:
    virtual void setSpeed(float speed) {};// do nothing in the case of elastic loop for the time being...
    virtual void setSize(float size) {}; // do nothing in the case of elastic loop for the time being...
    virtual void speedFactor(float speedfactor);
    virtual void sizeFactor(float sizeFactor) {}; // do nothing in the case of elastic loop for the time being...
       
    virtual void explosion() {}; // nothing for the time being 
    virtual vector2Df getCenter() {}; // nothing for the time being
    virtual void resetPositionSpeed() {};// nothing for the time being 
    virtual void setPositionSpeed(vector2Df _pos, vector2Df _spe) {};// nothing for the time being 
 
    virtual void showChildParameters();
 
    // methods that are new to this class (not in base class): 
    void initSizeBlob(int _numMasses);
    void createLoopFromScafold(void);
    void processLoopData(); // process elastic loop data
    
       // ====================== VARIABLES ======================

    //ElasticLoopMode loopMode;

    // The loop of masses with springs:
    int numMasses; // Number of particles in the elastic loop (this may or may not be equal to the number of points in the lsdTrajectory)
    float integrationStepLoop;
    vector<pointMass> massesLoop;
    vector<spring> loopSpringArray;
    // NOTE: to save memory, we can drop hairVector (use lightForce instead, and then normalize it when required)
    vector<vector2Df> hairVector; // the perpendiculars to the loop 
    vector<vector2Df> lightForce;
    //vector2D totalLightForce; // this belongs to the base class now
   
    // For the central anchor point:
    pointMass anchorMass;
    float  integrationStepAnchor;
    vector<spring> centralSpringArray;
    
    // Detail modes (could be in a struct)
    // Behaviour mode:
    bool pseudopodesMode;
    bool slidingDirection; // for contour following
    bool springForcesOnLoop;
    bool lightForcesOnLoop;
    bool forceBorderOnLoop;
    bool recenteringForceOnLoop;
    bool nuclearForceOnLoop;
    bool interParticleForceOnLoop;
    bool forceInternalPressureOnLoop;
    bool recenteringForceOnNucleus;
        
    // Recentering vector (obtained by rotating the total light force by an arbitrary angle) for the anchor mass, and for each point in the loop 
    // ex: if it is 180deg, then the blob just "bounces" on the zone transition; if it is 90, it does contour following... 
  
    // The following are common to all blobs:
   //  float angleCorrectionForceLoop;
   // vector2D recenteringVectorLoop;
   // float angleRecenteringVector; // auxiliary variables for sending data (for the recenteringVectorLoop)
   // float normRecenteringVector;
   
    float angleCorrectionForceNucleus;
    vector2Df recenteringVectorNucleus;
     
    // Numeric parameters: 
    float massLoopParticle; 
    float dampMotionMassesLoop;
    float massAnchor;
    float dampMotionAnchorMass;
    
    // initial size, position and center-mass speed of the elastic loop:
    float startRadius;
    //vector2D startCenter; // this belongs to the base class
    // vector2D startSpeed; // this belongs to base class
    
    float interSpringK, interSpringRelax;
    float centralSpringK, centralSpringRelax;
    float factorLightForce;
    float factorRecenteringAnchorMass;
    float factorRecenteringLoopMass;
    float factorPressureLoopMass;
    float factorForceBorder;
    float interParticleRange, factorInterParticleForce; // zach like blob force
    
  // SOUND SENDING MODES (specific to this kind of blob object): 
  /*
  // (a) anchor mass data: 
  bool sendingAnchorPosition;
  bool sendingAnchorForce; // this is the total force on the anchor mass, not just the recentering force
  bool sendingAnchorTouchWall;
  // (b) data from blob points:
  bool sendingLoopPositions;
  bool sendingLoopForces;// this is not just the forces from light, but all the forces in each particle
  bool sendingLoopForcesLight;
  bool sendingLoopRegions; // from this we can detect "hits"
  bool sendingLoopTouchWall;
  // (c) Blob geometry:
  bool sendingBlobArea;
  bool sendingBlobNormals;
  bool sendingBlobAngles; // redundant with sendingBlobNormals, but simplified (only angle of normal)
    */
    
};

#endif
