#include "classRigidScafold.h"
 
 RigidScafold::RigidScafold() {
 }
 
 RigidScafold::~RigidScafold() {
 }
 

 void  RigidScafold::buildCircularScafold(float _radius, vector2Dd _pos, int _numScafoldPoints) {
    sizeScafold=_radius;
    centerScafold=_pos;
    scafold.resize(_numScafoldPoints);
    float angInc= 2.0 * PI / _numScafoldPoints;
    float ang=0;
    for (int i = 0; i < scafold.size(); i++) {
        scafold[i]= vector2Dd( cos(ang)* _radius, sin(ang)* sizeScafold )   + centerScafold; 
        // note: I cannot do vector2Dd( cos(ang), sin(ang) ) * _radius because vector2Dd would give (0,0)
        ang+=angInc;
    }
}

// Modifying the scafold (resizing, rotating): 
// Note: in case of elastic loop, the mass-loop may be reinitialized or not (if the rigid loop is used as "attractor" only):

 void  RigidScafold::resizeDimensionScafold(float _newSize) {
    resizeFactorDimensionScafold(_newSize/sizeScafold);
    sizeScafold=_newSize;
 }

 void  RigidScafold::resizeFactorDimensionScafold(float _factor) {
    for (int i = 0; i < scafold.size(); i++) {
        scafold[i] = ( scafold[i]-centerScafold)*_factor+centerScafold; 
    }
    sizeScafold*=_factor;
}

void RigidScafold::rotateScafold(float alphadeg) { 
// note: rotate around the centerScafold:
    for (int i = 0; i < scafold.size(); i++) {
        scafold[i]=(scafold[i]-centerScafold).getRotatedRad(alphadeg)+centerScafold;
    }
}
  
 void  RigidScafold::buildLine(float _length, float _angleDeg, vector2Dd _pos, int _numScafoldPoints) {
   scafold.resize(_numScafoldPoints);
   vector2Dd auxStep = vector2Dd(_length * cos(_angleDeg/180.0 * PI)/_numScafoldPoints, sin(_length * _angleDeg/180.0 * PI)/_numScafoldPoints ) ;
    for (int i = 0; i < scafold.size(); i++) {
        scafold[i]= auxStep * i + _pos;
    }
}

  // Other functions to create letters, text, etc. 
  // ... TO DO ....
  
 