#ifndef simpleLaserSensingRenderer_h
#define simpleLaserSensingRenderer_h

#include "blobConfig.h"
// Include hardware interface for display and sensing:
#include "hardwareIO.h"

//extern DigitalOut myled3; // for tests...

//#define debugDelayMirrors // this is to check visually the mirror delay (but it is also beautiful)

#define RED_BLANKING // note: RED blanking introduces problems because the Lock-in looses signal, but we can add more points to compensate when there 
// are many blobs, see "DEFAULT_OVERLAP_POINTS" (but will slow down...)

#define RENDER_INTERVAL 0.00011 // good value in previous version (monaco) was 0.00011 // in seconds (Ticker)

#define WAIT_NORMAL 0 // good :0 // (minimum is 0) waiting time for setting mirror position MINUS waiting laser time (note that this total waiting time may be equal to 0 if we set a good sampling freq for the renderer, but 
// and if the shape is regular so that this time does not change significatively - this is not the case for multiple blobs or highly deformed blobs). 
#define WAIT_LASER  0  // (minimum is 0) waiting time for activating the laser (if there are color changes IN BETWEEN points). Maybe needed for the green laser
// WHEN THERE IS MORE THAN ONE SPOT:
#define WAIT_FIRST 12 // special waiting time for mirror positioning to first point on next blob BEFORE re-activating laser
#define WAIT_FIRST_LASER 0  // IMPORTANT waiting time for the activation of the RED laser and LOCK-IN (also waiting time for the mirrors)
#define WAIT_LAST 0  // special waiting time for last point 

// Redundant drawing for avoiding deformed saccade (note: this could be active when there is more than one blob, instead of using a #define...)
#define DEFAULT_OVERLAP_POINTS 5 // 10

enum lsdStateType {NORMAL_POINT, LAST_POINT, MOVE_NEXT_BLOB, START_POINT};

class simpleLaserSensingRenderer {
public:

    void setConfigToRender(blobConfig*); 
    //void startRenderer(); // pb: I cannot use the ticker function inside the class!
    void laserRenderThread();
    void laserRenderThreadONEBLOBONLY();
   // void laserRender(blobConfig*);
    
    blobConfig* ptBlobCfToRender;
    
    lsdStateType stateLsd;
    int totalBlobs;
    int currentBlob;
    int currentPoint;
    int currentMirrorDelay;
    int currentTotalPoints;
    int currentColor;
    unsigned short x,y; // auxiliary variables storing mirror position(0-4096)
    
    // New method to check complete display of one loop:
    unsigned char configTotalPoints;
    unsigned char pointDisplayCounter;
    unsigned char numOverlapPoints;
    
    void startFullDisplay();
    bool endedFullDisplay();
    bool endedFractionDisplay(int fract);
    
    int waitNormal, waitLaser, waitFirst, waitFirstLaser, waitLast;
};

#endif


 
