
#ifndef hardwareIO_h
#define hardwareIO_h

#include "mbed.h"
#include "lockin.h"
#include "CRotaryEncoder.h"


// potentiometer to change sensitivity by hand, or other things... ACTUALLY THIS IS NOT WORKING because I cannot switch back and forth from 
// burst mode of analog conversion and "normal" one. Better use a rotary encoder!!
#define POT_ANALOG_INPUT p15 // note: analog inputs in the mbed are from 15 to 20

// Momentary switches triggering INTERRUPT functions:
// (Any of the numbered mbed pins can be used as an InterruptIn, except p19 and p20)
// NOTE: do not use pins from p21 to p26 because they are all set as pwm output (see lockin.h)
#define LED_SWITCH_ONE p9 // digital output pin
#define SWITCH_ONE p10 // interrupt pin
#define SWITCH_TWO p11 // interrupt pin

// Two state switch: 
#define TWO_STATE_SWITCH p12

// NOTE: the SPI library uses the following pins, but we don't have to set them and inputs or outputs (this is done when the library is initialized, which is done by pre-instantiation. 
#define SCK_PIN   p7 //SPI Clock
#define MISO_PIN  p6 //SPI input (data comming from DAC, here not connected) 
#define MOSI_PIN  p5 //SPI output (data going to DAC)

//**** CHIP SELECT pins for MP4922 DAC (mirrors and red laser)
#define CS_DAC_MIRRORS   p8 

//**** LASERS pins:
#define LASER_RED_PIN   p28 // NOT YET USED!! (NOTE: this is NOT the locking sensing laser (also called red, but could be infrared...)
#define LASER_GREEN_PIN p29 // USED (TTL control)
#define LASER_BLUE_PIN  p30 // USED (TTL control)

//**** MIRRORS: 
//The DAC is 12 bytes capable (Max=4096), but we will limit this a little. 
#define MAX_AD_MIRRORS 4000//3845 // note: 4095 is the absolute maximum for the SPI voltage (5V). This is for checking hardware compliance, but max and min angles can be defined for X and Y in each LivingSpot instance.
#define MIN_AD_MIRRORS 155//250  // note: 0 is 0 volts for the SPI voltage. 
// We assume that the center of the mirror is at MAX_AD_MIRRORS/2 = 2000:
#define CENTER_AD_MIRROR_X 2047 // This MUST BE the direction of the photodetector. 
#define CENTER_AD_MIRROR_Y 2047 // This MUST BE the direction of the photodetector.


//**** Look-Up Table:
#define uint16 unsigned short
#define LUT_RESOLUTION  33   // resolution of the Look-Up Table (power of 2 +1)
#define LUT_BITS_SHIFT  7    // bits shift from mirror DAC (12 bits) to LUT ( root_square(LUT_RESOLUTION - 1) )
#define LUT_BITS_MASK   127   // bits mask to obtain the position remainder ( 2^LUT_BITS_SHIFT - 1 )
//  possible configurations:
//  LUT_RESOLUTION  LUT_BITS_SHIFT  LUT_BITS_MASK
//      9               9               511
//      17              8               255
//      33              7               127
//      65              6               63
//  ...
#define NB_SCANS 8 // number of scans performed to generate the LUT table (actually, each site CUMULATES NB_SCANS values)
                   // IMPORTANT: NB_SCANS*4095 should not exceed the capacity of uint16, this is 2^16-1=65535.
                   // In other terms, NB_SCANS should be < 65535/4095=16

#define LUT_FILENAME "/local/LUT.txt"

// For checking (define if human readable file is required - note: it is not used by the program, just as output for human reading)
#define LUT_H_FILENAME "/local/LUT_pos.txt"

// Current Look-up table approximation (only one at a time!): 
//#define LUT_BILINEAR 
//#define LUT_DIRECT
//#define LUT_LINEAR
#define NO_LUT

//Current method for lockin data acquisition and correction
#define lockin_read() lockin.getMedianValue() // lockin.getSmoothValue(); //return the average of the value stored on the buffer
                                              // lockin.getLastValue(); //return the last conversion of the ADC
                                              // lockin.getMedianValue(); //return the median value of the buffer



// **** REFERENCE SIGNAL: 
/*
#define testPin_OC1A 11 // this is, output compare pin OC1A //connected to CK2 = lockIn clock
#define testPin_OC1B 12 // this is, output compare pin OC1B //connected to CK1 = laser clock
#define testPin_OC1C 13
*/

// ==================================================================================================================================================================

class HardwareIO {
public:


    void init(void);

    //Lock-in acquisition methods:
   // float LockInRead_Volts(); 
   // int LockInRead_AD(); 
  //  float LockInAD_to_Volts(int); 
    
    //Look-Up Table:
    unsigned short lut[LUT_RESOLUTION][LUT_RESOLUTION]; //Look-Up Table (uint16 is "unsigned short")
    void scanLUT(); //create and save the Look-Up Table
    void setLUT(); //set the Look-Up Table: either from scanning, or from the file LUT.TXT (if it is present)
    float lockInCorrectedValue(unsigned short x, unsigned short y); //return the lockin value corrected with the Look-UpTable (this is, a RATIO of reflectivities, and <1)
    
    void scan_serial(unsigned short pointsPerLine = 400);

    void showLimitsMirrors( int times );

    // SPI control for DAC for mirrors and red laser power (low level): 
    void writeOutX(unsigned short value);
    void writeOutY(unsigned short value);
    
    // mirror degree-to-AD units conversion factors: 
    //float AD_to_Deg_MIRROR_X;//=1.0*(MAX_DEG_MIRROR_X-MIN_DEG_MIRROR_X)/(MAX_AD_MIRRORS-MIN_AD_MIRRORS);
    //float AD_to_Deg_MIRROR_Y;//=1.0*(MAX_DEG_MIRROR_Y-MIN_DEG_MIRROR_Y)/(MAX_AD_MIRRORS-MIN_AD_MIRRORS);

    /*
    // Mirror position:
    void setMirrorX_Deg(float _Az); 
    void setMirrorY_Deg(float _El);
    void setMirrorX_AD(int _AzAD); 
    void setMirrorY_AD(int _ElAD);
    void setMirrorsXY_AD(int _xAD, int _yAD); 
    void setMirrorsCenter();
    void getAnglesFromAD(float &Az, float &El, int _xAD, int _yAD); 
    //void setZoneDelimiters(...) // this could be here, instead on the LivingSpot class
    */
    
    
    //Laser Power, for the moment laser are TTL but we can use int:
    //if powerValue > 0 ==> 'true'; else 'false'
    void setLaserLockinPower(int powerLockingLaser);   
    // Red laser (not used)
    void setRedPower(int powerRed);
    // Green laser: 
    void setGreenPower(int powerGreen);
    // Blue laser: 
    void setBluePower(int powerBlue);

    void setRGBPower(unsigned char color); // we will use the 3 LSB bits to set each color, note that here the "red" is the LOCKIN LASER
    
    //void setupPWM();
    /* IN ADVANCED HARDWARE: 
    // init PWM for reference generation:
    void initPWM();
    // reference signal: 
    void setRefFreq(int);
    void incRefFreq(int inc=1);
    void decRefFreq(int dec=1);
    */

    //float refFreq; // could be private
    
    // Interrupt "momentary" switches: 
    bool switchOneState, switchTwoState;
    bool switchOneChange, switchTwoChange;
    void switchOneInterrupt();
    void switchTwoInterrupt();
    bool switchOneCheck(bool& state);
    bool switchTwoCheck(bool& state);
    void setSwitchOneState(bool newstate);
    
    // two state switch: 
    bool twoStateSwitchState;
    bool twoStateSwitchChange;
    bool twoStateSwitchCheck(bool& stateswitch);

    // Potentiometer (does not work!!)
    unsigned char updatePotValue(); // the value will be ajusted in the range 0-255
    unsigned char potValue;
    
private:
     //DigitalOut Laser_Red, Laser_Green, Laser_Blue;
     
};


extern HardwareIO IO; // allows the object IO to be used in other .cpp files (IO is pre-instantiated in hardwareIO.cpp)
// NOTE: IO encapsulates many IO functions, but perhaps it is better not to have an IO object - just use each IO function separatedly (as with pc object for instance)
extern Serial pc; // allows pc to be manipulated by other .cpp files, even if pc is defined in the hardwareIO.cpp


#endif
