#ifndef RIGIDSCAFOLD_H
#define RIGIDSCAFOLD_H

 #include "myVectorClass.h"
 
 #include <vector>
 using namespace std;
  
 class RigidScafold {
 public:
    RigidScafold();
    ~RigidScafold();
    
    // (1) METHODS for creating different SCAFOLD structures
 // Note: these scafolds may or may not be used to initialize the light loop (in case of elasticLoop). 
  void buildCircularScafold(float _radius, vector2Dd _pos, int _numScafoldPoints);
  void buildLine(float _length, float _angleDeg, vector2Dd _pos, int _numScafoldPoints);
  // void buildStarScafold....
  
  // Other functions to create letters, text, etc. 
  // ...
  
   // Transformations of the scafold (resize, shear, rotation...):
  void resizeDimensionScafold(float _newSize);
  void resizeFactorDimensionScafold(float _factor);
  void rotateScafold(float alphadeg);
  
  
  // DATA structures: 
    // note: the number of points in the scafold does not need to equate the number of points in the blob
    vector<vector2Dd> scafold; // scafold trajectory (either float or unsigned short). 
    vector2Dd centerScafold;
    float sizeScafold;
    // Notes: - Centered around the centerScafold point.
    //        - Can be used to initialize elastic loop.
 };

#endif