/*
 *  pointMass.h
 *  laserBlob
 *
 *  Created by CASSINELLI ALVARO on 5/19/11.
 *  Copyright 2011 TOKYO UNIVERSITY. All rights reserved.
 *
 */

#ifndef POINTMASS_H
#define POINTMASS_H

#include "myVectorClass.h"

#define VERLET_METHOD // comment this to have EULER method

#define MAX_PERMISSIBLE_SPEED 35

class pointMass
{
public:
    
    // ==================================== Static variables and methods ============== 
    static vector2Df maxWall, minWall; //equal for ALL THE MASS OBJECTS (declare static). But it could be per-mass. The problem with that approach would be too much wasted memory. 
    // NOTE: - a static member variable has the same value in any instance of the class and doesn't even require an instance of the class to exist.
    //       - a static class member cannot be initialized inside of the class declaration. In fact, if you decide to put your code in a header file, you cannot even initialize the static variable 
    //         inside of the header file; do it in a .cpp file instead. Moreover, you are required to initialize the static class member or it will not be in scope. 
    //         The syntax is a bit weird: "type class_name::static_variable = value", or in this case vector2Df pointMass::maxWall(4095, 4095)
   
    // methods:
    static void setWallLimits(float mminx, float mminy, float mmaxx, float mmaxy);
    
    // ==================================== METHODS ====================================
    pointMass();
    virtual ~pointMass(){};
        
    // Adding forces to total force:
    void resetForce();
    void addForce(float x, float y);
    void addForce(vector2Df force);
    void addDampingForce();
    void addInvSquareForce(float x, float y, float radiusMax, float radiusMin, float scale);
    void addInterInvSquareForce(pointMass &p, float radiusMin, float radiusMax, float scale);
        
    // (a blob object could be defined by a "cord" of chained particles, plus a center)
    void addSpringForce(float x, float y,  float radius, float scale);
    void addInterSpringForce(pointMass &p, float radius, float scale);
    //void addClockwiseForce(particle &p, float radius, float scale);
    //void addCounterClockwiseForce(particle &p, float radius, float scale);
    
    //void addDampingForce(); // this work in the case of the euler integration; in case of Verlet, we need to do pseudo-damping while calculating
    // the acceleration... 
    
    // Set parameters:
    void setInitialCondition(float px, float py, float vx, float vy);
    void setInitialCondition(vector2Df _pos, vector2Df _speed);
    void setIntegrationStep(float _dt);
    
    void setPos(float px, float py); // assuming the speed is unchanged (must do some tweaking in case of Verlet integration)
    
    // dynamic update:
    void update();
    
    // kinematic constraints (could be based on a force too...)
    //void setWallLimits(float mminx, float mminy, float mmaxx, float mmaxy); // DECLARED STATIC
    void bounceOffWalls();
    
    vector2Df getSpeed(); // get an estimation of the speed (also update speed variable - this variable is not needed in case of VERLET)
    void setSpeed(const vector2Df& vel);
    void setSpeed(float vx, float vy);
    
    // ==================================== VARIABLES ====================================
    
    int identifier; // this may be needed in particular in case we don't use vector<> (case of poor C Arduino compiler)
    
    // kinematic variables:
    vector2Df  pos, posOld; // I will use verlet integration (perhaps we could have a switch to choose the integration method?)
    //vector2D  speed; // speed at time t (this is not explicitly calculated in case of verlet method, HENCE PRIVATE)
    vector2Df  acc;   // Acceleration at time t (equal to the total force divided by the mass). No real need to have it here, but convenient to check. 
    vector2Df  totalForce; // this is just for convenience and speeding up calculation when adding forces, before computing acc. 
    
    // integration step:
    float dt; 
    
    // physical parameters:
    float dampMotion;
    float dampBorder;
    float mass;
    bool  bFixed; // these could act as control points that could be loaded (letters...). In fact, we could use mass to set this (like mass=-1)
    
    // other things:   
    bool bWallCollision; // this is generic (detect any collision with a side)
    vector2Df innerCollitionDirection; // this is smarter than a boolean, because I can detect which side was touched and do different things (but may be memory consuming)
    
protected:
    
private:
      vector2Df  speed; // speed at time t (this is not explicitly calculated in case of verlet method, HENCE MAY BE PRIVATE)
    
};


#endif //POINTMASS_H