#ifndef SOUNDSPOT_H
#define SOUNDSPOT_H

//#define SEND_AS_BLOB // for test (sending positions in a single OSC blob chunk)
//#define SEND_AS_STRING
#define SEND_AS_POINTS

// The global object OSC for sending/receiving messages:
#include "mbedOSC.h"
extern OSCMessage recMes;
extern OSCMessage sendMes;
extern OSCClass osc;

extern DigitalOut myled2; // for tests...

#include "classLaserSensingTrajectory.h"
#include "classRigidScafold.h"


#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) > (b)) ? (a) : (b))

// This is a polymorphic class, and elasticLoop, livingSpot are derived classes that
// instantiate particular methods (update, etc).
class soundSpot {
protected: // (note: protected means that the child classes will have access to these variables/methods; private means that only this class members have access)

    // number of points of this blob:
    int numPoints; // this in fact is equal to sensingTrajectory.size() for instance.
    Timer measureSendPeriod;
    
public:

    // CONSTRUCTOR AND DESTRUCTOR --------------------------------------------------------------------------------------------------------------
    soundSpot();
    // Destructor (virtual, because one can only delete an object of a derived type
    // through a pointer to one of its base classes IF the base class has a virtual destructor)
    virtual ~soundSpot();// { cout<<"Destroying Base";}

    // METHODS -------------------------------------------------------------------------------------------------------------
    // COMMON methods to all the kind of blobs:
    // (1) properties of the visible loop:
    void setColor(unsigned char c);
    void setGreenColor(unsigned char c);
    void setBlueColor(unsigned char c);
    
    // (2) Sending modes:
    void stopAllSending(void);
    void resetAllSendingModes(void);
    void initCommonVariables();
    void sendData(void); // send data common to all kind of blobs
    
    // VIRTUAL METHODS (common to all blobs, but each type of blob will implement it differently):
    // Blob creation:
    virtual void setRegionMotion(float mmix, float mmiy, float mmax, float mmay)=0;
// virtual void createBlob()=0; // note: the number of masses in the blob will be given from the scafold.
//  virtual void createBlob(int _id, ElasticLoopMode _elasticBlobMode, vector2D _initPos)=0;
    // Update:
    virtual void update(vector2Df referencePos=vector2Df(0,0))=0;
    virtual void computeBoundingBox(void)=0; // this is virtual because the displayed blob may be the scafold itself (in case of laser spot), or the elastic loop.
    // Draw (on lsdTrajectory):
    virtual void draw(void)=0; // NOTE: this method actually "renders" the trajectory using the laser renderer (not yet done)
// Send data through OSC:
    virtual void sendDataSpecific(void)=0; // send data specific to each blob

// Some parameters (very different treatement for each type of blob):
    virtual void setSpeed(float speed=7.0)=0;
    virtual void setSize(float size=20.0)=0;
    virtual void speedFactor(float speedfactor=100.0)=0;
    virtual void sizeFactor(float sizeFactor=100.0)=0;
    
    void addAngleCorrection(float _moreAngleCorrection);
    void setAngleCorrection(float _angleCorrection);

   virtual void explosion()=0; // not very nice programming style, it should be a MODE instead or something like that. 
   virtual vector2Df getCenter()=0;
   virtual void resetPositionSpeed()=0; 
   virtual void setPositionSpeed(vector2Df _pos, vector2Df _spe)=0;
   
   virtual void showChildParameters()=0; 
   void printParameters(); // first show common parameters, then call the virtual method:
    
    // DATA --------------------------------------------------------------------------------------------------------------
    int identifier; //0, 1, 2...
    char spotName[20]; //spot, elastic,... (this may be useful to set particular variables by forcing type cast (bad, but couldn't find a more elegant solution for the moment)
    unsigned char blobColor, transientBlobColor; // transient blob color is the color of the blob when touching something for instance. 
    bool blueTouch; // this is equivalent to "debugDelayMirrors" #define, but per-blob (ie. blue active in dark zones). Good for elastic loops...
    
    // initial position and speed of the blob:
    vector2Df startCenter;
    vector2Df startSpeed;
    
    // Special fields:
    vector2Df gravity;

    // SCAFOLD (rigid structure of points, with a center and methods to create it):
    RigidScafold bluePrint;

    // LASER DISPLAY/SENSING-TRAJECTORY with DATA BUFFER for each blob:
    LaserSensingTrajectory displaySensingBuffer;

// the following are common to all kind of blobs, but the way these quantities are calculated (in the update() method) differs greatly:
    vector2Df totalLightForce;
    vector2Df recenteringVectorLoop;
    float angleCorrectionForceLoop;
    float angleRecenteringVector; // auxiliary variables for sending data (for the recenteringVectorLoop)
    float normRecenteringVector;

    // Geometry/kinematics of the loop:
    float cx, cy, w, h;
    float area, approxArea;
    float totalKineticEnergy;

    bool render; // when false, the blob is NOT RENDERED
    bool standByMode; // when true, the blob is NOT UPDATED

    // something touched the blob:
    bool searchActive;
    bool firstTimeNoTouch;
    //bool lightTouched; // belongs to the lsdTrajectory
    int noTouchedCounter;
    vector2Df randomForce;

    // the blob touched the wall limits (these variables are updated in the "update" method, and implemented differently for each blob)
    bool blobWallCollision;
    int wallCounter;

    // HARDWARE SENDING MODE (can be changed by serial or osc commands):
    unsigned short periodSendingData; // max data rate for sending data (in ms)
    bool sendSerial;
    bool sendOSC;
    bool sendingOnlyWhenTouch; // when this is "true", data will be send ONLY when something touches the blob (border or light touch). Note that the max speed of sending
                               // will be limited to periodSendingData. 
    // SENDING modes for things COMMON TO ALL THE KIND OF BLOBS:
    // (d) Light sensing statistics:
    bool sendingBlobMaxMin; // max and min intensities are calculated directly from the lsdTrajectory
    bool sendingTouched; // when someone touches the blob (can be calculated directly from the lsdTrajectory)
    bool sendingLightForce; // the total light force (note: this CANNOT be calculated on the lsdTrajectory, but on the update method, particular to each loop).
    // (e) Recentering vector: (note: redundant with sendingLightForce, IF the correction angle is known).
    bool sendingRecenteringVector;
    bool sendingRecenteringAngle;
    bool sendingRecenteringNorm;

    // SPECIFIC TO EACH BLOB (move this from here, use virtual methods to set their values):
    // (a) anchor mass data:
    bool sendingAnchorPosition;
    bool sendingAnchorForce; // this is the total force on the anchor mass, not just the recentering force
    bool sendingAnchorTouchWall;
    // (b) data from blob points:
    bool sendingLoopPositions;
    bool sendingLoopForces;// this is not just the forces from light, but all the forces in each particle
    bool sendingLoopForcesLight;
    bool sendingLoopRegions; // from this we can detect "hits"
    bool sendingLoopTouchWall;
    // (c) Blob geometry/kinematics:
    bool sendingBlobArea;
    bool sendingKineticEnergy;
    bool sendingBlobNormals;
    bool sendingBlobAngles; // redundant with sendingBlobNormals, but simplified (only angle of normal)
};

#endif