#ifndef LSDTRAJECTORY_H
#define LSDTRAJECTORY_H

#include <vector>
using namespace std;

// Thresholding mode: 
enum thresholdingMode {FIXED, AUTO};
enum lightStateMode {TOUCHED, ALL_LIGHT, ALL_DARK};

//(1) fixed threshold: 
#define FIXED_THRESHOLD 35

//(1) Autothreshold:
// CONTRAST RATIO to compute autoThreshold:
// MIN_CONTRAST_RATIO is the minimum contrast between max and min intensity necessary to "accept" a black and white zone:
#define MIN_CONTRAST_RATIO 2.0//2.5//1.6//1.8//1.7 // 3 seems good when lookup table does not work 
// THRESHOLD_FACTOR is where the threshold is actually placed between the min and max detected (with good contrast):
#define THRESHOLD_FACTOR 0.5 //0.75 // 2/3 or 1/2 are good values 
#define MIN_ACCEPTABLE_INTENSITY 16 // if maxI< this then we consider all the saccade on something black

struct laserSensingPoint {
    // Position and color (after rendering)
   unsigned short x, y; // position of the point (after rendering - its integer, because it is in "laser projector pixels")
    // char color; // per point laser color (not used yet)
    // Detection:
    unsigned char intensity; // detected intensity (in fact, this will be the REFLECTIVITY RATIO if using LUT table, and it's between 0 and 1, but we will multiply by 255 to avoid using a float. 
    signed char lightZone; // the thresholded light zone (allow for negative values for simply computing "negative" forces - although this is not necessarily the best option)
};


class LaserSensingTrajectory  {

public:

    LaserSensingTrajectory();
    ~LaserSensingTrajectory();

    // METHODS:
    bool processSensedData();
    void setDelayMirrors(int); // in general, the delay will depend on the number of points being DISPLAYED (in other terms, on the size of lsdTrajectory).
    void addDelayMirrors(int add_delay);

    void setThresholdMode(unsigned char value) {modeThreshold=(value>0? AUTO : FIXED);};
    void setFixedThreshold(unsigned char value) {fixedThreshold=value;};
    void setMinContrastRatio(float value) {min_contrast_ratio=value;};
    void setThresholdFactor(float value) {threshold_factor=value;};
    void setMinAcceptableIntensity(unsigned char value) {min_acceptable_intensity=value;};
    void multMinContrastRatio(float multfactor) {min_contrast_ratio*=multfactor;};
    void multThresholdFactor(float multfactor) {threshold_factor*=multfactor;};

    // DATA:
    vector <laserSensingPoint> lsdTrajectory;
    unsigned char displayColor; // per blob color

    // software adjustement of mirror delay:
    unsigned char delayMirrorSamples; // this is required because it will affect the way the blob behaves - it 
    //could be in the laser renderer, but by putting it here we can have more per-blob fine tunning

    // parameters for thresholding and thresholding mode:
    thresholdingMode modeThreshold;
    float min_contrast_ratio, threshold_factor, min_acceptable_intensity;
    unsigned char autoThreshold, fixedThreshold; // 0 to 255
    
    // Statistics and tests:
    //float lightRatio;
    unsigned char maxI, minI;     // Max and Min intensity RATIOS (normalized between 0 and 255)
    // The following is a little redundant, but useful:
    bool lightZone, darkZone; // better than a boolean lightTouched variable, but lightTouched may still be useful
    lightStateMode lightState;
    bool lightTouched;     // when there is at least one black zone and one light zone
};

#endif


