#include "mbed.h"
#include "mbedOSC.h"

DigitalOut myled(LED1);

// mbed IP address (server):
#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
  IpAddr(10,0,0,2), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(10,0,0,1), //Gateway
  IpAddr(10,0,0,1)  //DNS
);
#endif

//uint8_t serverMac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
uint8_t serverIp[]  = { 10, 0, 0, 2 }; // not needed perhaps!
int  serverPort  = 10000;
  
uint8_t destIp[]  = { 10, 0, 0, 1};
int  destPort = 12000;
  
char *topAddress="/mbed";
char *subAddress[3]={ "/test1" , "/test2" , "/test3" };
  
OSCMessage recMes;
OSCMessage sendMes;
  
OSCClass osc;    
//OSCClass osc(&recMes);  // instantiate OSC communication object, and set the receiver container from the OSC packets  
 
 Serial pc(USBTX, USBRX); 
 
void processOSC(UDPSocketEvent e); 
 
int main() {
    
  // make debug port:
  pc.baud(115200);

  // Set the Ethernet port: 
  printf("Setting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\r\n", ethErr);
    return -1;
  }
  printf("Setup OK\r\n");
    
  
   //(1) Sending message:
   // Set IP and Port: 
   sendMes.setIp( destIp );
   sendMes.setPort( destPort );
   // Set data: 
   // sendMes.setTopAddress(topAddress);
   
   //setting osc functionnality:
   //(2) Receiving: 
  // recMes.setIp( serverIp ); // not needed?
   osc.setReceiveMessage(&recMes); // this sets the receiver container for the OSC packets (we can avoid doing this if we use osc.getMessage() to get messages)
   osc.begin(serverPort, &processOSC); // binds the upd (osc) messages to an arbitrary listening port ("server" port), and callback function
   
   //==========================================   INFINITE LOOP (in USER PROGRAM CONTEXT) ===================================================================
    while(true) {
        Net::poll();
        
        // ... Do whatever needs to be done (note: the osc processing is done in the processOSC function. 
        // BUT DO NOT FORGET to call osc.onUDPSocketEvent(e). This is messy... should find a better way to do it. 
    
    }
}


// This is the callback function called when there are packets on the listening socket. It is not nice to have it 
// here, but for the time being having a "wrapping global" is the simplest solution (we cannot pass a member-function pointer 
// as handler to the upd object).  
void processOSC(UDPSocketEvent e) {
    osc.onUDPSocketEvent(e);

    if (osc.newMessage) { // in fact, there is no need to check this if using the method of a global callback function - it is clear this is a new packet... however, it may be 
                          // interesting to use a timer, and process data (answers, etc) only after a certain amount of time, so as to avoid blocking the program in IRQ context...
        
             //pc.printf("we received top address %s\n", recMes.getAddress(0) );
             
            osc.newMessage=false; // note: if using: message=osc.getMessage(), then we don't need to do this explicitly. 
        
            // Test: 
            if( !strcmp( recMes.getAddress(0) , "mbed" ) ) {
                pc.printf("we received topAddress= mbed \n");
                if( !strcmp( recMes.getAddress(1) , "test1" ) )
                      pc.printf("we received subAddress= test1 \n");
                      
                      // Send some osc message:
                      sendMes.setTopAddress("/working...");
                      osc.sendOsc(&sendMes);
            }
        }
       
}


/* EXAMPLE SEND/RECEIVE on PROCESSING:

// oscP5sendreceive by andreas schlegel
// example shows how to send and receive osc messages.
// oscP5 website at http://www.sojamo.de/oscP5

 
import oscP5.*;
import netP5.*;
  
OscP5 oscP5;
NetAddress myRemoteLocation;

void setup() {
  size(400,400);
  frameRate(25);
  // start oscP5, listening for incoming messages at port 12000 
  oscP5 = new OscP5(this,12000);
  
  // myRemoteLocation is a NetAddress. a NetAddress takes 2 parameters,
  // an ip address and a port number. myRemoteLocation is used as parameter in
  // oscP5.send() when sending osc packets to another computer, device, 
  // application. usage see below. for testing purposes the listening port
  // and the port of the remote location address are the same, hence you will
  // send messages back to this sketch.
  myRemoteLocation = new NetAddress("10.0.0.2",10000);
}


void draw() {
  background(0);  
}

void mousePressed() {
  // in the following different ways of creating osc messages are shown by example 
  OscMessage myMessage = new OscMessage("/mbed/test1");
  
  myMessage.add(123); // add an int to the osc message 

  // send the message 
  oscP5.send(myMessage, myRemoteLocation); 
}


// incoming osc message are forwarded to the oscEvent method. 
void oscEvent(OscMessage theOscMessage) {
  // print the address pattern and the typetag of the received OscMessage 
  print("### received an osc message.");
  print(" addrpattern: "+theOscMessage.addrPattern());
  println(" typetag: "+theOscMessage.typetag());
}

*/
