#include "mbed.h"
#include "laserProjectorHardware.h"

DigitalOut myled(LED1);

void processSerial();

unsigned int X, Y; // position of the mirror (note: in fact it is an ANGLE)
bool newPositionReady=false;

unsigned int counter=0;

int main() {

    // SETUP: --------------------------------------------------------------------------------------------
    IO.init(); // note: serial speed can be changed by checking in the hardwareIO.cpp initialization
  
    // Set displaying laser powers: 
    IO.setRedPower(0);
    IO.setGreenPower(0);//turn on the green (displaying) laser

    wait_ms(100);

    Y = CENTER_AD_MIRROR_Y;
    IO.writeOutY(Y);
    
    // MAIN LOOP: --------------------------------------------------------------------------------------------
    while(1) {
        processSerial();
        if (newPositionReady) {
            IO.writeOutY(Y);
            newPositionReady=false;
        }
        
       Y=int(0.5*4095.0*(1.0+cos(1.0*counter/100000)));
       IO.writeOutY(Y);
       counter++;
        
    }
}

// --------------------------------------------------------------------------------------------
// String to store ALPHANUMERIC DATA (i.e., integers, floating point numbers, unsigned ints, etc represented as DEC) sent wirelessly: 
char stringData[24]; // note: an integer is two bytes long, represented with a maximum of 5 digits, but we may send floats or unsigned int...
int indexStringData=0;//position of the byte in the string

void processSerial() {

 while(pc.readable()>0){
      
    char val =pc.getc();
  
  // Save ASCII numeric characters (ASCII 0 - 9) on stringData:
    if ((val >= '0') && (val <= '9')){ // this is 45 to 57 (included)
      stringData[indexStringData] = val;
      indexStringData++;
    }

  // X value?
  else if (val=='X') {
    stringData[indexStringData] = 0 ;
    X=atoi(stringData);
    indexStringData=0;
    //newPositionReady=true;
  }
    // Y value?
    else if (val=='Y') {
    stringData[indexStringData] = 0 ;
    Y=atoi(stringData);
    indexStringData=0;
    newPositionReady=true;
  }
 
 }
}