#include "laserProjectorHardware.h"

HardwareIO IO; // preintantiation of cross-file global object IO

// --------------------------------------  (0) SETUP ALL IO (call this in the setup() function in main program)

Serial pc(USBTX, USBRX); // tx, rx

 SPI spiDAC(MOSI_PIN, MISO_PIN, SCK_PIN); // mosi, miso, sclk
 DigitalOut csDAC(CS_DAC_MIRRORS);
       
 DigitalOut Laser_Red(LASER_RED_PIN); // NOTE: this is NOT the lock in sensing laser (actually, not used yet)
 DigitalOut Laser_Green(LASER_GREEN_PIN);
 DigitalOut Laser_Blue(LASER_BLUE_PIN);

void HardwareIO::init(void) {
    Laser_Red = 0; // note: this is not the lockin-laser!
    Laser_Green = 0;
    Laser_Blue = 0;
    
    //Serial Communication setup:
    pc.baud(115200);//
   //  pc.baud(921600);//115200);//
    
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 10MHz clock rate
    csDAC = 1;
    spiDAC.format(16,0);
    spiDAC.frequency(16000000);
   
   // default initial mirror position: 
    writeOutX(CENTER_AD_MIRROR_X);
    writeOutY(CENTER_AD_MIRROR_Y);
    
}

//write on the first DAC, output A (mirror X)
void HardwareIO::writeOutX(unsigned short value){
 if(value > MAX_AD_MIRRORS) value = MAX_AD_MIRRORS;
 if(value < MIN_AD_MIRRORS) value = MIN_AD_MIRRORS;
 
 value |= 0x7000;
 value &= 0x7FFF;
 
 csDAC = 0;
 spiDAC.write(value);
 csDAC = 1;
}

//write on the first DAC, output B (mirror Y)
void HardwareIO::writeOutY(unsigned short value){
 if(value > MAX_AD_MIRRORS) value = MAX_AD_MIRRORS;
 if(value < MIN_AD_MIRRORS) value = MIN_AD_MIRRORS;
 
 value |= 0xF000;
 value &= 0xFFFF;
 
 csDAC = 0;
 spiDAC.write(value);
 csDAC = 1;
}

void HardwareIO::setRedPower(int powerValue){
    if(powerValue > 0){
        Laser_Red = 1;
    }
    else{
        Laser_Red = 0;
    }
}
void HardwareIO::setGreenPower(int powerValue){
    if(powerValue > 0){
        Laser_Green = 1;
    }
    else{
        Laser_Green = 0;
    }
}
void HardwareIO::setBluePower(int powerValue){
    if(powerValue > 0){
        Laser_Blue = 1;
    }
    else{
        Laser_Blue = 0;
    }
}
void HardwareIO::setRGBPower(unsigned char color) {
    //lockin.setLaserPower(color&0x04>0? false : true);
    Laser_Red=color&0x04>>2;
    Laser_Green=(color&0x02)>>1;
    Laser_Blue =color&0x01;
}

void HardwareIO::showLimitsMirrors(int times) {
      unsigned short pointsPerLine=150;
      int shiftX = (MAX_AD_MIRRORS - MIN_AD_MIRRORS) / pointsPerLine;
      int shiftY = (MAX_AD_MIRRORS - MIN_AD_MIRRORS) / pointsPerLine;
   
      Laser_Green=1;
   
     //for (int repeat=0; repeat<times; repeat++) {
     
     Timer t;
     t.start();
     while(t.read_ms()<times*1000) {
       
      writeOutX(MIN_AD_MIRRORS);writeOutY(MIN_AD_MIRRORS);
   
      for(int j=0; j<pointsPerLine; j++){   
       wait_us(200);//delay between each points
       writeOutY(j*shiftY + MIN_AD_MIRRORS);
       }
      
      writeOutX(MIN_AD_MIRRORS);writeOutY(MAX_AD_MIRRORS);
      for(int j=0; j<pointsPerLine; j++) {
         wait_us(200);//delay between each points
         writeOutX(j*shiftX + MIN_AD_MIRRORS);
         }
      
      writeOutX(MAX_AD_MIRRORS);writeOutY(MAX_AD_MIRRORS);
      for(int j=0; j<pointsPerLine; j++) {
         wait_us(200);//delay between each points
         writeOutY(-j*shiftX + MAX_AD_MIRRORS);
         }
      
       writeOutX(MAX_AD_MIRRORS);writeOutY(MIN_AD_MIRRORS);
      for(int j=0; j<pointsPerLine; j++) {
         wait_us(200);//delay between each points
         writeOutX(-j*shiftX + MAX_AD_MIRRORS);
         }
      
      }
      t.stop();
      Laser_Green=0;
}
