#ifndef LASER_SENSING_DISPLAY_h
#define LASER_SENSING_DISPLAY_h

#include "mbed.h" // we will use in particular the Ticker object
#include "hardwareIO.h" // Include hardware interface for display and sensing
#include "Scene.h"

//extern laserSensingDisplay lsd; // pre-instantiated in the implementation file. 

// =====================================================================================================================
// NOTE: it would be much better to be able to wait in between points depending on the distance from these; but this is too computationally expensive here (perhaps!), 
// so for the time being, it would be better to compute "optimal trajectories" with repetitive points if necessary on the pc side...

// =====================================================================================================================

//#define debugDelayMirrors // this is to check visually the mirror delay (but it is also beautiful)

#define SENSING_LASER_BLANKING // note: this blanking introduces problems because the Lock-in looses signal, but we can add more points to compensate when there 
// are many blobs, see "DEFAULT_OVERLAP_POINTS" (but will slow down...)

#define RENDER_INTERVAL 0.000053 //0.0001 is good for CALIBRATION grid, 0.000054 good for normal display // in seconds (Ticker)

#define WAIT_NORMAL 0 //1 // good :0 // (minimum is 0) waiting time for setting mirror position MINUS waiting laser time (note that this total waiting time may be 
//equal to 0 if we set a good sampling freq for the renderer, but  and if the shape is regular so that this time does not change significatively - this is not 
// the case for multiple blobs or highly deformed blobs). 
#define WAIT_LASER  2  // Good 5 for grid. (minimum is 0) waiting time for properly powering the laser (if there are color changes IN BETWEEN points). Maybe needed for the green laser
// WHEN THERE IS MORE THAN ONE SPOT:
#define WAIT_FIRST 10// Good 7 for grid. 12 // special waiting time for mirror positioning to first point on next 
// blob BEFORE re-activating laser

// ****IMPORTANT: IN FACT WAITING TIMES SHOULD DEPEND ON THE DISTANCE BETWEEN THE POINTS. AND THAT'S ALL*****

#define WAIT_FIRST_LASER 0  // IMPORTANT waiting time for the activation of the RED laser and LOCK-IN (also waiting time for the mirrors)
#define WAIT_LAST 2  // special waiting time for last point 

// Redundant drawing for avoiding deformed saccade (note: this could be active when there is more than one blob, instead of using a #define...)
// NOTE: THIS IS ONLY MEANINFUL IF THE OBJECT IS A LOOP!!!
#define DEFAULT_OVERLAP_POINTS 0 // 10

enum lsdStateType {START_FIRST_OBJECT, NORMAL_POINT, LAST_POINT, MOVE_NEXT_OBJECT, START_POINT};

typedef struct {
    // to do!
} lsdParams;

class laserSensingDisplay {
    public:
    
    // constructor:
    laserSensingDisplay(); 

    // We can "attach" any scene to display (if laserSensingDisplay object is an ivar of LaserRenderer lsr, then all this will be set at the LaserRenderer init):
    void setSceneToDisplay(Scene* );
    // NOTE: as this does display AND sensing, I cannot separate the 3d SCENE points from the 2d FRAME points. I call
    // therefore the "frame and scene" as just the "scene" for the time being.
    Scene* ptSceneToDisplay;
        
    //void startRenderer(); // pb: I cannot use the ticker function inside the class!
    void laserDisplayThread();
    void run(); // start the ticker on laserDisplayThread
    void stop(); // stop the ticker on laserDisplayThread
    bool isRunning(); 
    
    lsdStateType stateLsd;
    unsigned char totalObjects; // I assume no more than 255 objects!
    unsigned char currentObject;
    unsigned short currentPoint;
    unsigned char currentMirrorDelay;
    unsigned short currentTotalPoints;
    unsigned char currentColor;
    
    unsigned short x,y; // auxiliary variables storing mirror position(0-4096)
    
    // New method to check complete display of one loop:
    unsigned short configTotalPoints;
    unsigned short pointDisplayCounter;
    unsigned char numOverlapPoints; // I assume no more than 255 points of overlap!
    bool isDisplayingOver();
    void startDisplayCheck();
    
    unsigned char waitNormal, waitLaser, waitFirst, waitFirstLaser, waitLast;
    
    private:
    
    // Ticker to run/stop the ISR "laserDisplayThread()"
    Ticker timerForRendering; // note: this is the only file that uses this object (attach and detach).
    bool runningState; 
    bool displayingFinished;
};

#endif


 

