#include "mbed.h"
#include "laserProjectorHardware.h"

DigitalOut myled(LED3);

void processSerial();

unsigned int X, Y; // position of the mirrors (note: in fact, azimuth and elevation)
bool newPositionReady=false;
bool handshakeMode=true;
unsigned long counter=0;

int main() {

    // SETUP: --------------------------------------------------------------------------------------------
    IO.init(); // note: serial speed can be changed by checking in the hardwareIO.cpp initialization

    wait_ms(100);

    Y = CENTER_AD_MIRROR_X;
    X = CENTER_AD_MIRROR_Y;
    IO.writeOutXY(X,Y);
    
    // MAIN LOOP: --------------------------------------------------------------------------------------------
    while(1) { 
    
   // myled=0;IO.setRedPower(1); 
   // wait_ms(1000); 
   //  myled=1;IO.setRedPower(0);
   //  wait_ms(1000); 
   
  // Y = CENTER_AD_MIRROR_X+1000*cos(1.0*counter/10);
//    X = CENTER_AD_MIRROR_Y+800*sin(1.0*counter/15);
//    IO.writeOutXY(X,Y);
// counter++;
   
   
   //IO.drawCircle(X, Y, 1000, 200);
   
        processSerial();
        if (newPositionReady) {
          IO.writeOutXY(X,Y);
          //IO.drawCircle(X, Y, 1000, 20);
            newPositionReady=false;
        }
    }
}

// --------------------------------------------------------------------------------------------
// String to store ALPHANUMERIC DATA (i.e., integers, floating point numbers, unsigned ints, etc represented as DEC) sent wirelessly: 
char stringData[24]; // note: an integer is two bytes long, represented with a maximum of 5 digits, but we may send floats or unsigned int...
int indexStringData=0;//position of the byte in the string

void processSerial() {

 while(pc.readable()>0) {
   
    char val =pc.getc();
  
  // Save ASCII numeric characters (ASCII 0 - 9) on stringData:
    if ((val >= '0') && (val <= '9')){ // this is 45 to 57 (included)
      stringData[indexStringData] = val;
      indexStringData++;
            
    }
    
  // X value?
  else if (val=='X') {
    stringData[indexStringData] = 0 ;
    X=atoi(stringData);
    indexStringData=0;
  }
   
  // Y value?
  else if (val=='Y') {
    stringData[indexStringData] = 0 ;
    Y=atoi(stringData);
    indexStringData=0;
    newPositionReady=true;
    if (handshakeMode) pc.putc('A');// send acknowledgement of correctly received position:
   }
   
   else if (val=='H') { // this sets handshake mode to ON or OFF:
    stringData[indexStringData] = 0 ;
    if(atoi(stringData)>0) handshakeMode=true; else handshakeMode=false;
    indexStringData=0;
   }
   
    else if (val=='L') {     
    stringData[indexStringData] = 0 ;
    //if(atoi(stringData)>0)  IO.setRedPower(1); else  IO.setRedPower(0);
     if(atoi(stringData)>0)  IO.setLockinPower(1); else  IO.setLockinPower(0); // for the time being, we only use the lockin laser
    indexStringData=0;
  }
 
  else if (val=='S') {     
    stringData[indexStringData] = 0 ;
   IO.showLimitsMirrors(int(atoi(stringData)));
    indexStringData=0;
  }
  
  else if (val=='C') {     
    stringData[indexStringData] = 0 ;
    if(atoi(stringData)>0) {
   IO.drawCircle(2048, 2048, 1200, 2000, int(atoi(stringData)));
   }
    indexStringData=0;
  }
 
 }
}