
#ifndef hardwareIO_h
#define hardwareIO_h

#include "mbed.h"
#include "lockin.h"


// NOTE: the SPI library uses the following pins, but we don't have to set them and inputs or outputs (this is done when the library is initialized, which is done by pre-instantiation. 
#define SCK_PIN   p7 //SPI Clock
#define MISO_PIN  p6 //SPI input (data comming from DAC, here not connected) 
#define MOSI_PIN  p5 //SPI output (data going to DAC)

//**** CHIP SELECT pins for MP4922 DAC (mirrors and red laser)
// VERY IMPORTANT: the chip select for the DACs should be different from the default SPI "SS" pin (Slave Select), which is 53 by default (and will be used by the Ethernet Shield). 
#define CS_DAC_MIRRORS   p8 //Chip Select of the first DAC (mirrors)

//**** LASERS pins:
#define LASER_RED_PIN   p28
#define LASER_GREEN_PIN p29
#define LASER_BLUE_PIN  p30

//**** MIRRORS: 
//The DAC is 12 bytes capable (Max=4096), but we will limit this a little. 
#define MAX_AD_MIRRORS 4095 // Absolute maximum for the SPI voltage (5V). This is for checking hardware compliance, but max and min angles can be defined for X and Y in each LivingSpot instance.
#define MIN_AD_MIRRORS 0
// We assume that the center of the mirror is at MAX_AD_MIRRORS/2 = 2000:
#define CENTER_AD_MIRROR_X 2047 // This MUST BE the direction of the photodetector. 
#define CENTER_AD_MIRROR_Y 2047 // This MUST BE the direction of the photodetector.


// **** REFERENCE SIGNAL: 
/*
#define testPin_OC1A 11 // this is, output compare pin OC1A //connected to CK2 = lockIn clock
#define testPin_OC1B 12 // this is, output compare pin OC1B //connected to CK1 = laser clock
#define testPin_OC1C 13
*/

// ==================================================================================================================================================================

class HardwareIO {
public:


    void init(void);

    float LockInRead_Volts(); 
    int LockInRead_AD(); 
    float LockInAD_to_Volts(int); 

    // SPI control for DAC for mirrors and red laser power (low level): 
    void writeOutX(int value);
    void writeOutY(int value);
    
    // mirror degree-to-AD units conversion factors: 
    //float AD_to_Deg_MIRROR_X;//=1.0*(MAX_DEG_MIRROR_X-MIN_DEG_MIRROR_X)/(MAX_AD_MIRRORS-MIN_AD_MIRRORS);
    //float AD_to_Deg_MIRROR_Y;//=1.0*(MAX_DEG_MIRROR_Y-MIN_DEG_MIRROR_Y)/(MAX_AD_MIRRORS-MIN_AD_MIRRORS);

    /*
    // Mirror position:
    void setMirrorX_Deg(float _Az); 
    void setMirrorY_Deg(float _El);
    void setMirrorX_AD(int _AzAD); 
    void setMirrorY_AD(int _ElAD);
    void setMirrorsXY_AD(int _xAD, int _yAD); 
    void setMirrorsCenter();
    void getAnglesFromAD(float &Az, float &El, int _xAD, int _yAD); 
    //void setZoneDelimiters(...) // this could be here, instead on the LivingSpot class
    */
    
    
    //Laser Power, for the moment laser are TTL but we can use int:
    //if powerValue > 0 ==> 'true'; else 'false'
    // Red laser:
    void setRedPower(int powerRed);
    // Green laser: 
    void setGreenPower(int powerGreen);
    // Blue laser: 
    void setBluePower(int powerBlue);

    
    //void setupPWM();
    /* IN ADVANCED HARDWARE: 
    // init PWM for reference generation:
    void initPWM();
    // reference signal: 
    void setRefFreq(int);
    void incRefFreq(int inc=1);
    void decRefFreq(int dec=1);
    */

    //float refFreq; // could be private

    
private:

};


extern HardwareIO IO; // allows the object IO to be used in other .cpp files (IO is pre-instantiated in hardwareIO.cpp)
// NOTE: IO encapsulates many IO functions, but perhaps it is better not to have an IO object - just use each IO function separatedly (as with pc object for instance)
extern Serial pc; // allows pc to be manipulated by other .cpp files, even if pc is defined in the hardwareIO.cpp


#endif
