#include "hardwareIO.h"

HardwareIO IO; // preintantiation of cross-file global object IO

// --------------------------------------  (0) SETUP ALL IO (call this in the setup() function in main program)

 Serial pc(USBTX, USBRX); // tx, rx

 SPI spiDAC(MOSI_PIN, MISO_PIN, SCK_PIN); // mosi, miso, sclk
 DigitalOut csDAC(CS_DAC_MIRRORS);
    
 DigitalOut Laser_Red(LASER_RED_PIN);
 DigitalOut Laser_Green(LASER_GREEN_PIN);
 DigitalOut Laser_Blue(LASER_BLUE_PIN);

void HardwareIO::init(void) {
    Laser_Red = 1;
    Laser_Green = 0;
    Laser_Blue = 0;
    
    //Serial Communication setup:
    pc.baud(115200);//921600);
    
    // Setup for lock-in amplifier and pwm references:
    lockin.init();
    
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 10MHz clock rate
    csDAC = 1;
    spiDAC.format(16,0);
    spiDAC.frequency(16000000);
   
   // default initial mirror position: 
    writeOutX(CENTER_AD_MIRROR_X);
    writeOutY(CENTER_AD_MIRROR_Y);
}

//write on the first DAC, output A (mirror X)
void HardwareIO::writeOutX(int value){
 if(value > MAX_AD_MIRRORS) value = MAX_AD_MIRRORS;
 if(value < MIN_AD_MIRRORS) value = MIN_AD_MIRRORS;
 
 value |= 0x7000;
 value &= 0x7FFF;
 
 csDAC = 0;
 spiDAC.write(value);
 csDAC = 1;
}

//write on the first DAC, output B (mirror Y)
void HardwareIO::writeOutY(int value){
 if(value > MAX_AD_MIRRORS) value = MAX_AD_MIRRORS;
 if(value < MIN_AD_MIRRORS) value = MIN_AD_MIRRORS;
 
 value |= 0xF000;
 value &= 0xFFFF;
 
 csDAC = 0;
 spiDAC.write(value);
 csDAC = 1;
}

void HardwareIO::setRedPower(int powerValue){
    if(powerValue > 0){
       lockin.setLaserPower(true);
    }
    else{
       lockin.setLaserPower(false);
    }
}
void HardwareIO::setGreenPower(int powerValue){
    if(powerValue > 0){
        Laser_Green = 1;
    }
    else{
        Laser_Green = 0;
    }
}
void HardwareIO::setBluePower(int powerValue){
    if(powerValue > 0){
        Laser_Blue = 1;
    }
    else{
        Laser_Blue = 0;
    }
}
