#ifndef TCPLISTENER_H
#define TCPLISTENER_H

#include "tcpitem.h"

#include "arch/cc.h"
#include "lwip/err.h"
#include "lwip/tcp.h"

namespace mbed {
  class NetServer;

  class TCPListener : public TCPItem {
    public:
      TCPListener(u16_t port) : _port(port) { 
        _pcb = tcp_new();
        tcp_arg(this->_pcb, static_cast<void *>(this));
      }

      /**
       * Function to call when a listener has been connected.
       * @param err an error argument (TODO: that is current always ERR_OK?)
       * @return ERR_OK: accept the new connection,
       *                 any other err_t abortsthe new connection
       */
      virtual err_t accept(struct tcp_pcb *, err_t err) = 0;
    private:
      void bind();
      
      u16_t _port;
    friend NetServer;
  };

};

#endif /* TCPLISTENER_H */