#ifndef LWIPOPTS_H
#define LWIPOPTS_H

#include <string.h>
#include <stdlib.h>
#include <mbed.h>


#ifdef __cplusplus
using namespace std;
#endif

// Application specific lwIP Options.
#define IPv6                            0
#define NO_SYS                          1
#define LWIP_ARP                        1
#define LWIP_RAW                        1
#define LWIP_UDP                        1
#define LWIP_TCP                        1
#define LWIP_DNS						1
#define LWIP_DHCP                       1
#define LWIP_IGMP                       1
#define LWIP_SNMP                       0
#define LWIP_SOCKET                     0
#define LWIP_NETCONN                    0
#define LWIP_AUTOIP                     1
#define LWIP_CALLBACK_API               1

#define MEM_LIBC_MALLOC					1
#define MEM_ALIGNMENT                   4
#define MEM_SIZE						

#define ARP_QUEUEING                    0
#define LWIP_NETIF_HOSTNAME             1

/*
#define EMAC_ADDR12         0x0000000D
#define EMAC_ADDR34         0x0000873A
#define EMAC_ADDR56         0x00000EC0
*/
/*
#define EMAC_ADDR12         0x00000030
#define EMAC_ADDR34         0x00006C00
#define EMAC_ADDR56         0x00000002
*/
/*
#define EMAC_ADDR12         0x0000101F
#define EMAC_ADDR34         0x0000E012
#define EMAC_ADDR56         0x00001D0C
*/
/*
#define EMAC_ADDR12         0x0000001E
#define EMAC_ADDR34         0x00003732
#define EMAC_ADDR56         0x00000A50
*/


#define HIGHEST_PRIORITY	0x01
#define LOWEST_PRIORITY		0x0F

#define	WDT_INT			0
#define SWI_INT			1
#define ARM_CORE0_INT	2
#define	ARM_CORE1_INT	3
#define	TIMER0_INT		4
#define TIMER1_INT		5
#define UART0_INT		6
#define	UART1_INT		7
#define	PWM0_1_INT		8
#define I2C0_INT		9
#define SPI0_INT		10			/* SPI and SSP0 share VIC slot */
#define SSP0_INT		10
#define	SSP1_INT		11
#define	PLL_INT			12
#define RTC_INT			13
#define EINT0_INT		14
#define EINT1_INT		15
#define EINT2_INT		16
#define EINT3_INT		17
#define	ADC0_INT		18
#define I2C1_INT		19
#define BOD_INT			20
#define EMAC_INT		21
#define USB_INT			22
#define CAN_INT			23
#define MCI_INT			24
#define GPDMA_INT		25
#define TIMER2_INT		26
#define TIMER3_INT		27
#define UART2_INT		28
#define UART3_INT		29
#define I2C2_INT		30
#define I2S_INT			31

#define VIC_SIZE		32

#define LWIP_DEBUG       1
#define LWIP_DBG_TYPES_ON ~0x0
#define LWIP_DBG_MIN_LEVEL   0
//#define TCP_OUTPUT_DEBUG	(LWIP_DBG_ON | LWIP_DBG_LEVEL_WARNING)
//#define NETIF_DEBUG     (LWIP_DBG_ON | LWIP_DBG_LEVEL_WARNING)
//#define DHCP_DEBUG      (LWIP_DBG_ON | LWIP_DBG_LEVEL_WARNING)
//#define IP_DEBUG        (LWIP_DBG_ON | LWIP_DBG_LEVEL_WARNING)
//#define TCP_DEBUG       (LWIP_DBG_ON | LWIP_DBG_LEVEL_WARNING)

#endif
