/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * NOTE: This is an unsupported legacy untested library.
 */
#include "SPIHalfDuplex.h"

#if DEVICE_SPI

#include "spi_api.h"
#include "PinNames.h"
#include "pinmap.h"

#define GPIO_MODE 0
#define SPI_MODE  2

namespace mbed {

SPIHalfDuplex::SPIHalfDuplex(PinName mosi, PinName miso, PinName sclk,
        const char *name) : SPI(mosi, miso, sclk, name) {
    _mosi = mosi;
    _miso = miso;
    _sbits = _bits;
}

void SPIHalfDuplex::slave_format(int sbits) {
    _sbits = sbits;
}

int SPIHalfDuplex::write(int value) {
    int t_bits = _bits;
    pin_function(_mosi, SPI_MODE);
    int ret_val = SPI::write(value);
    if(ret_val != value) {
        return -1;
    }
    format(_sbits, _mode);
    pin_function(_mosi, GPIO_MODE);
    ret_val = SPI::write(0x55);
    format(t_bits, _mode);
    pin_function(_mosi, SPI_MODE);
    return ret_val;
}

} // end namespace mbed

#endif
