#include "mbed.h"
#include "cmsis_os.h"

osMessageQDef(queue, 5, message_t);
osMessageQId  queue;

DigitalOut myled(LED1);

void queue_isr() {
    osMessagePut(queue, (uint32_t)2, 0);
    
    myled = !myled;
}

void queue_thread(void const *args) {
    while (true) {
       osMessagePut(queue, 1, 0);
       osDelay(1000);
    }
}

osThreadDef(queue_thread, osPriorityNormal, DEFAULT_STACK_SIZE);

int main (void) {
     queue = osMessageCreate(osMessageQ(queue), NULL);
    
    osThreadCreate(osThread(queue_thread), NULL);
    
    Ticker ticker;
    ticker.attach(queue_isr, 1.0);
    
    while (true) {
        osEvent evt = osMessageGet(queue, osWaitForever);
        if (evt.status != osEventMessage) {
            printf("queue->get() returned %02x status\n\r", evt.status);
        } else {
            printf("queue->get() returned %d\n\r", evt.value.v);
        }
    }
}
