#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"

Ticker flash;
DigitalOut led(LED1);
void flashLED(void){led = !led;}

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p30, p29, "mbed", "password", WPA);

int main() 
{
    flash.attach(&flashLED, 1.0f);
    
    wifly.init(); //Use DHCP
    while(!wifly.connect());
    printf("IP Address: %s\n", wifly.getIPAddress());

    // view @ http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    while (!ws.connect());
    char str[100];
    
    for(int i=0; i<0x7fffffff; ++i) {
        // string with a message
        sprintf(str, "%d WebSocket Hello World over Wifi", i);
        ws.send(str);
    
        // clear the buffer and wait a sec...
        memset(str, 0, 100);
        wait(0.5f);
    
        // websocket server should echo whatever we sent it
        if (ws.read(str)) {
            printf("rcv'd: %s\n", str);
        }
    }
    ws.close();
    wifly.disconnect();
    
    while(true);
}