
#include "websocketstest.h"
#include "Websocket.h"

void websocketstest(CellularModem& modem, const char* apn, const char* username, const char* password)
{
    char msg[2048] = {0};
    Timer t;
    
    t.start();
    modem.power(true);
    Thread::wait(1000);
    int ret = modem.connect(apn, username, password);  
    if(ret)
    {
        error("Modem connect failed: %s line %d\n", __FILE__ , __LINE__);
    }
    
    // See the output on http://sockets.mbed.org/sg_test/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/sg_test/rw");
 
    for(int i=0; i<0x7fffffff; ++i)
    {
        ws.connect();
        // create json string with acc/tmp data
        sprintf(msg, "Testing mbed Websockets Loop: %d", i);
        ws.send(msg);    
        wait(0.5f);
        memset(msg, 0, 2048);
        
        if (ws.read(msg))
        {
            printf("rcv: %s\r\n", msg);
        }
        else
        {
            printf("Loop %d ws.read() returns 0\n \t %s, line %d @ %6.2f seconds\n", i, __FILE__, __LINE__, t.read());
            wait(5.0f);
        }
        ws.close();
    }
    
    t.stop();
    modem.disconnect();
    modem.power(false); 
    
    puts("Powered off Test Complete");
}
