#include "Blinky.h"
#include "mbed.h"
#include "greentea-client/test_env.h"
#include "unity.h"
#include "utest.h"
#include "rtos.h"
 
using namespace utest::v1;
 
//All tests will blink the LED 5 times
const int expected_blinks = 5;
 
//Generic blink test
//interval => the the amount of time between blinks
//led => PinName of LED to blink
void test_blinks(PinName led, int interval){
    //Set an appropriate wait time to measure exactly expected_blinks
    //with the given interval 
    float wait_time = interval*(2*expected_blinks-1);
    //Create Blinky
    Blinky blinker(led, interval);
    //start blinky
    blinker.start();
    //Wait the appropriate amount of time for expected_blinks 
    Thread::wait(wait_time);
    blinker.stop();
    
    float measured_blinks = blinker.times_blinked();
    //Only assert if failure
    TEST_ASSERT(measured_blinks == (float)expected_blinks);
}
 
void blink_500(){
    //Blinky with a 500 ms interval between blinks
    test_blinks(LED1, 500);
}
void blink_1000(){
    //Blinky with a 1000 ms interval between blinks
    test_blinks(LED1, 1000);
}
 
utest::v1::status_t test_setup(const size_t number_of_cases) {
    // Setup Greentea using a reasonable timeout in seconds
    GREENTEA_SETUP(40, "default_auto");
    return verbose_test_setup_handler(number_of_cases);
}
 
// Test cases
Case cases[] = {
    Case("Testing 500 ms interval", blink_500),
    Case("Testing 1000 ms interval", blink_1000),
};
 
Specification specification(test_setup, cases);
 
// Entry point into the tests
int main() {
    return !Harness::run(specification);
}