/* mbed blinky
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MBED_BLINKY_H
#define MBED_BLINKY_H
#include "mbed.h"
#include "rtos.h"

/** Interface to start a thread that blinks an LED
 */
class Blinky {
public:
    /** Create a Blinky 
     *
     * @param led A PinName, the pin name of the LED to blink
     * @param interval A int, the interval of time between LED blinks
     */
    Blinky(PinName led, int interval);
    /**Start a thread executing blink_led*/
    void start();
    /**Terminate the thread blinking the LED*/
    void stop();
    /**Find the number of times the LED has been blinked */
    float times_blinked();
    
protected:
    /**Function to blink the LED*/
    void blink_led();
    /**Thread to execute blink_led*/
    Thread _blinker;
    /**LED to blink */
    DigitalOut _led;
    /**Interval of time between blinks*/
    int _interval;
    /**Bool to stop blinking LED */
    bool stop_blink;
    /**Count of times LED blinked */
    float led_count;
};
#endif
    
    