#include "mbed.h"
//-------------------------------------------------------------------------------
//Port Settings
DigitalOut led1(LED1);
DigitalOut led2(P1_13,1);

DigitalIn sw(P1_20);
DigitalIn isp(P0_1);

//These ports can be PWM port
PwmOut bz(P0_8);
//PwmOut bz(P0_9);
//PwmOut bz(P0_18);
//PwmOut bz(P0_19);

volatile float Hz[] = {
    220.000,//A3
    246.942,//B3
    261.626,//C4
    293.665,//D4
    329.628,//E4
    349.228,//F4
    391.995,//G4
    440.000,//A4
    493.883,//B4
    523.251,//C5
    587.330,//D5
    659.255,//E5
    698.456,//F5
    783.991,//G5
    880.000//A5
};
    
//-------------------------------------------------------------------------------
//Program
int main()
{

    while(1)
    {
        // Button "SW" function
        if(sw == 0)
        {
            led1 = 0;//LED1 turn ON
            
            //PWM output
            for (int i = 0;i < 14;i++)
            {
                bz.period(1.0 / Hz[i]);// set to pulse period : (1.0 / xxx[Hz]) = T[sec]
                bz.write(0.5);// set to pulse L/H duty : ex. (0.8) = 80% High
                wait(0.3);// wait for 0.3 sec
                bz.write(0.0);//PWM stop : pulse 0% (100% Low)
            }
        }    
        else
        {
            led1 = 1;//LED1 turn OFF
        }
        
        // Button "ISP" function
        if(isp == 0)
        {
            led2 = 0;//LED2 turn ON
            //PWM output
            bz.period(1.0 / 2000);// set to 2000[Hz]
            bz.write(0.5);// set to pulse L/H duty : ex. (0.8) = 80% High
            wait(0.15);// wait for 0.15 sec
            bz.period(1.0 / 1000);// set to 1000[Hz]
            bz.write(0.5);// set to pulse L/H duty : ex. (0.8) = 80% High
            wait(0.15);// wait for 0.15 sec
            
            bz.write(0.0);//PWM stop : pulse 0% (100% Low)
        }    
        else
        {
            led2 = 1;//LED2 turn OFF
        }
    }
}
