#include "mbed.h"
#include "SDFileSystem.h"
#include "LSM6DS3.h"
 
//-------------------------------------------------------------------------------
//Port Settings
DigitalOut led1(LED1);
DigitalOut led2(P1_13,0);
//DigitalOut USB_CONNECT(P0_6,0);
DigitalIn sw(P1_20);
DigitalIn isp(P0_1);
DigitalOut sd_en(P1_16, 1);//SD card power on/off control port. and ON default.
//DigitalIn sd_dat3(P0_17); // 0x10
//DigitalIn sd_dat2(P1_22); // 0x08
//DigitalIn sd_dat1(P1_14); // 0x04
//DigitalIn sd_dat0(P0_22); // 0x02
//DigitalIn sd_cmd(P0_21);  // 0x01
 
//-------------------------------------------------------------------------------
//
SDFileSystem fs(P0_21, P0_22, P1_15, P0_17, "sd"); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)
LSM6DS3 lsm(P0_5, P0_4, LSM6DS3_AG_I2C_ADDR(0) );//I2C ADDR 0x6A
 
 
//-------------------------------------------------------------------------------
//
int main()
{
    while(1)
    {
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
        
        if(sw == 0)
        {
            led2 = 0;
        }
        else
        {
            led2 = 1;
        }
        
        if(isp == 0)
        {       
            FILE *fp = fopen("/sd/TEST.txt", "w");
            if(fp != NULL)
            {
                lsm.begin();
                for(int i = 0;i < 5;i++)
                {
                    led2 = 0;
                    wait(0.1);
                    lsm.readGyro();
                    fprintf(fp,"gx:%f gy:%f gz:%f\r\n",lsm.gx ,lsm.gy ,lsm.gz);
                    lsm.readAccel();
                    fprintf(fp,"ax:%f ay:%f az:%f\r\n",lsm.ax ,lsm.ay ,lsm.az);
                    lsm.readTemp();
                    fprintf(fp,"temp:%f\r\n",lsm.temperature_c );
                    led2 = 1;
                    wait(0.3);
                }
                fprintf(fp,"\r\n");
                fclose(fp);
                free(fp);
            }
        }
    }
}
