#include "mbed.h"
//#include "FlashAir_iSDIO.h"
#include "SDFileSystem.h"
//#include "USBSerial.h"
#include "ADT7410.h"

#define USE_ADT7410
//-------------------------------------------------------------------------------
//Port Settings
DigitalOut led1(LED1);
//DigitalOut led2(P1_13,0);

InterruptIn sw(P1_20);
InterruptIn isp(P0_1);

DigitalOut sA1(P0_13,0);
DigitalOut sA2(P1_21,0); 
DigitalOut sB(P0_9,0);
DigitalOut sC(P0_20,0);
DigitalOut sD1(P0_14,0);
DigitalOut sD2(P1_26,0);
DigitalOut sE(P0_16,0);
DigitalOut sF(P0_11,0);
DigitalOut sG1(P0_23,0);
DigitalOut sG2(P0_8,0);
DigitalOut sJ(P0_12,0);
DigitalOut sK(P1_28,0);
DigitalOut sL(P1_31,0);
DigitalOut sP(P1_23,0);
DigitalOut sN(P1_27,0);
DigitalOut sM(P0_2,0);
DigitalOut sDP(P1_25,0);
DigitalOut SD_VEN(P1_16);
//Serial console(P0_19, P0_18); // TX, RX
//FlashAir_iSDIO sd(P0_21, P0_22, P1_15, P0_17, "sd", &console); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)
SDFileSystem sd(P0_21, P0_22, P1_15, P0_17, "sd"); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)

//USBSerial serial;
#ifdef USE_ADT7410
ADT7410 sensor(P0_5, P0_4, 0x90, 100000);
#else
int dummyval[] = {0,1,2,3,4,5,6,7,8,9};
#define DUMMYVALLEN (sizeof(dummyval)/sizeof(dummyval[0]))
#endif
float senseval;
int sense_int;

//-------------------------------------------------------------------------------
//Program

int wlan_connected = 0;
uint32_t sequenceId ;

void sw_int(){
    if(wlan_connected==1){
        // disconnect 
        // 1. get sequenceID
        // 2. issue disconnect command
        // 3. wait response 
        //sequenceId = sd.getNextSequenceId();
        //sd.wlan_disconnect(sequenceId);
        //sd.waitResponse(sequenceId);
        wlan_connected =0;
        led1 = 0;
        wait(5.0);
    }else{
        // establish
        // 1. get sequenceID
        // 2. issue establish command
        // 3. wait resoonse        
//        sequenceId = sd.getNextSequenceId();
//        sd.wlan_establish(sequenceId, "isdiotest", "12345678", FlashAir_iSDIO::ENCMODE_WPA2PSK_AES);
//        sd.waitResponse(sequenceId);
        led1 = 1;
//        wlan_connected =1;
        wait(5.0);
    
    }
}

void isp_int(){
    #define TESTDATA "deadbeaf"
    char testdata[] = TESTDATA;
    uint8_t data[sizeof(testdata)];
    memcpy(data, &testdata, sizeof(data));
//    sd.write_shared_mem(0x0, data, sizeof(data));
    wait(3.0);
}

void seg_disp(int val){
    switch((val/10)%10){
        case 0:sA1=1;sA2=1;sB=0;sF=0;sJ=1;sK=0;sL=1;break;
        case 1:sA1=1;sA2=1;sB=0;sF=0;sJ=0;sK=0;sL=0;break;
        case 2:sA1=0;sA2=0;sB=0;sF=1;sJ=1;sK=0;sL=1;break;
        case 3:sA1=0;sA2=0;sB=0;sF=0;sJ=1;sK=1;sL=1;break;
        case 4:sA1=1;sA2=1;sB=1;sF=0;sJ=0;sK=1;sL=0;break;
        case 5:sA1=0;sA2=1;sB=1;sF=0;sJ=1;sK=1;sL=0;break;
        case 6:sA1=1;sA2=1;sB=0;sF=0;sJ=1;sK=1;sL=0;break;
        case 7:sA1=0;sA2=0;sB=0;sF=0;sJ=1;sK=0;sL=1;break;
        case 8:sA1=1;sA2=1;sB=0;sF=0;sJ=1;sK=1;sL=1;break;
        case 9:sA1=0;sA2=1;sB=0;sF=0;sJ=1;sK=1;sL=1;break;
        default:sA1=0;sA2=0;sB=0;sF=0;sJ=0;sK=0;sL=0;break;
    }
    switch(val%10){
        case 0:sC=1;sD1=1;sD2=1;sE=1;sG1=1;sG2=1;sN=0;break;
        case 1:sC=0;sD1=1;sD2=1;sE=0;sG1=0;sG2=0;sN=0;break;
        case 2:sC=1;sD1=0;sD2=1;sE=1;sG1=1;sG2=0;sN=1;break;
        case 3:sC=1;sD1=1;sD2=1;sE=1;sG1=0;sG2=0;sN=1;break;
        case 4:sC=0;sD1=1;sD2=1;sE=0;sG1=0;sG2=1;sN=1;break;
        case 5:sC=1;sD1=1;sD2=0;sE=1;sG1=0;sG2=1;sN=1;break;
        case 6:sC=1;sD1=1;sD2=0;sE=1;sG1=1;sG2=1;sN=1;break;
        case 7:sC=1;sD1=1;sD2=1;sE=0;sG1=0;sG2=0;sN=0;break;
        case 8:sC=1;sD1=1;sD2=1;sE=1;sG1=1;sG2=1;sN=1;break;
        case 9:sC=1;sD1=1;sD2=1;sE=1;sG1=0;sG2=1;sN=1;break;
        default:sC=0;sD1=0;sD2=0;sE=0;sG1=0;sG2=0;sN=0;break;
    }
}

int out_file(float val)
{
    FILE *fd = fopen("/sd/test.txt", "a");
    fprintf(fd, "%.02f\r\n", val);
    fclose(fd);
    return 0;
}

int main()
{
    //console.printf("Hello FlashAIr_iSDIO_16seg_ADT7410\n");
    SD_VEN = 1;
    // Initialize card
//    FILE *fp = fopen("/sd/isdio.txt", "w");
//    fclose(fp);
    
#ifdef USE_ADT7410
    sensor.reset();
#endif

    // disconnect anyway    
//    sequenceId = sd.getNextSequenceId();
//    sd.wlan_disconnect(sequenceId);
//    sd.waitResponse(sequenceId);
    
    // register interrupt handler
    sw.rise(&sw_int);
    isp.rise(&isp_int);
    
    int i=0;
    while(1)
    {
#ifdef USE_ADT7410
        senseval = sensor.getTemp();
        sense_int = (int)sensor.getTemp();
#else
        senseval = dummyval[i];
#endif        
        seg_disp(sense_int);
        out_file(senseval);
        //serial.printf("%d\n",senseval);
        i++;
#ifndef USE_ADT7410
        if(i>=DUMMYVALLEN) i=0;
#endif
        wait(0.3);        
    }
}
