#include "mbed.h"
#include "SB1602E.h"
#include "SDFileSystem.h"

#define LOG_MAX 120

AnalogIn sensor(dp13);
SB1602E lcd( dp5, dp27 );
SDFileSystem sd(dp2, dp1, dp6, dp4, "sd");

int main() {
    int counter = 0;
    int16_t TmpLog[LOG_MAX];
    
    lcd.contrast(0x30);
    while(1) {
        float Temperature;
        
        Temperature = (sensor * 3.3 - 0.6) / 0.01;
        
        lcd.clear();
        lcd.printf(0,0,"%.2f",Temperature);
        
        if( counter < LOG_MAX )
        {
            TmpLog[counter] = (int16_t)(Temperature*100.0);
            counter++;
        }
        else if( counter == LOG_MAX )
        {
            FILE *fp = fopen("/sd/TempLog.csv", "w");
            for(int i=0;i<counter;i++)
            {
                fprintf(fp,"%d,%.2f\r\n",i,(float)TmpLog[i]/100.0);
            }
            fclose(fp);
            lcd.printf(0,1,"RecEnd");
            counter++;
        }
        else
        {
            lcd.printf(0,1,"RecEnd");
        }
        wait(60.0);
    }
}
