#include "mbed.h"
#include "SB1602E.h"

AnalogIn sensor(dp13);
Serial pc(USBTX, USBRX);
SB1602E lcd( dp5, dp27 );

int main() {
    lcd.contrast(0x30);
    while(1) {
        float Temperature;
        
        Temperature = (sensor * 3.3 - 0.6) / 0.01;
        
        pc.printf("Temperature = %f\r\n",Temperature);
        
        lcd.clear();
        lcd.printf(0,0,"%.2f",Temperature);
        
        wait(1.0);
    }
}
